/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.helper;

import java.util.Optional;
import org.ametys.cms.content.indexing.solr.SolrResourceGroupedMimeTypes;
import org.ametys.plugins.explorer.resources.jcr.JCRResource;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.workspaces.WorkspacesHelper;
import org.ametys.plugins.workspaces.calendars.Calendar;
import org.ametys.plugins.workspaces.calendars.CalendarColorsComponent;
import org.ametys.plugins.workspaces.tasks.Task;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class MailXSLTHelper
implements Serviceable {
    private static CalendarColorsComponent _calendarColors;
    private static AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        _calendarColors = (CalendarColorsComponent)manager.lookup(CalendarColorsComponent.ROLE);
        _resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public static String getFileTypeFromId(String resourceId) {
        try {
            JCRResource resource = (JCRResource)_resolver.resolveById(resourceId);
            return MailXSLTHelper.getFileType(resource.getMimeType());
        }
        catch (Exception e) {
            return WorkspacesHelper.FileType.UNKNOWN.name().toLowerCase();
        }
    }

    public static String getFileType(String mimeType) {
        Optional group = SolrResourceGroupedMimeTypes.getGroup((String)mimeType);
        return group.map(groupMimeType -> groupMimeType.toLowerCase()).orElse(WorkspacesHelper.FileType.UNKNOWN.name().toLowerCase());
    }

    public static String getCalendarColor(String calendarId) {
        try {
            Calendar calendar = (Calendar)_resolver.resolveById(calendarId);
            CalendarColorsComponent.CalendarColor color = _calendarColors.getColor(calendar.getColor());
            return color.getColor();
        }
        catch (UnknownAmetysObjectException e) {
            return _calendarColors.getColors().values().iterator().next().getColor();
        }
    }

    public static String getCalendarEventICSExportLink(String eventId, String projectURL) {
        if (_resolver.hasAmetysObjectForId(eventId)) {
            return projectURL + "/_plugins/workspaces/event.ics?eventId=" + eventId;
        }
        return "";
    }

    public static boolean hasDueDate(String taskId) {
        try {
            Task task = (Task)_resolver.resolveById(taskId);
            return task.getDueDate() != null;
        }
        catch (UnknownAmetysObjectException e) {
            return false;
        }
    }

    public static String getTaskICSExportLink(String taskId, String projectURL) {
        return projectURL + "/_plugins/workspaces/task.ics?id=" + taskId;
    }
}

