/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.modules;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModule;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;
import org.ametys.runtime.plugin.component.LazyInitializeExtensions;

@LazyInitializeExtensions
public class WorkspaceModuleExtensionPoint
extends AbstractThreadSafeComponentExtensionPoint<WorkspaceModule> {
    public static final String ROLE = WorkspaceModuleExtensionPoint.class.getName();
    private Set<String> _sortedIds;

    public <M extends WorkspaceModule> M getModule(String moduleId) {
        return (M)((WorkspaceModule)this.getExtension(moduleId));
    }

    public List<WorkspaceModule> getModules() {
        return this.getExtensionsIds().stream().map(id -> (WorkspaceModule)this.getExtension((String)id)).collect(Collectors.toList());
    }

    public WorkspaceModule getModuleByName(String moduleName) {
        List<WorkspaceModule> modules = this.getModules();
        for (WorkspaceModule workspaceModule : modules) {
            if (!workspaceModule.getModuleName().equals(moduleName)) continue;
            return workspaceModule;
        }
        return null;
    }

    public void initializeExtensions() throws Exception {
        super.initializeExtensions();
        TreeSet<WorkspaceModule> sortedModules = new TreeSet<WorkspaceModule>();
        sortedModules.addAll(this.getModules());
        this._sortedIds = sortedModules.stream().map(WorkspaceModule::getId).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<String> getExtensionsIds() {
        if (this._sortedIds != null) {
            return this._sortedIds;
        }
        return super.getExtensionsIds();
    }
}

