/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.notification;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.observation.Event;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.workspaces.members.JCRProjectMember;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.notification.AbstractMemberMailNotifierObserver;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class WelcomeMemberMailNotifierObserver
extends AbstractMemberMailNotifierObserver {
    public boolean supports(Event event) {
        return event.getId().equals("member.added") && (Boolean)Config.getInstance().getValue("workspaces.member.added.send.notification", true, (Object)false) != false;
    }

    @Override
    protected Map<String, List<String>> getUserToNotifyByLanguage(Event event, Project project) {
        GroupIdentity groupIdentity;
        Group group;
        String memberId = (String)event.getArguments().get("project.member.id");
        JCRProjectMember newMember = (JCRProjectMember)this._resolver.resolveById(memberId);
        String defaultLanguage = (String)StringUtils.defaultIfBlank((CharSequence)this._workspacesHelper.getLang(project), (CharSequence)this._userLanguagesManager.getDefaultLanguage());
        if (JCRProjectMember.MemberType.USER == newMember.getType()) {
            User user2 = this._userManager.getUser(newMember.getUser());
            String email = user2.getEmail();
            if (StringUtils.isNotEmpty((CharSequence)email) && this._isUserMemberNewToProject(user2.getIdentity(), project)) {
                return Collections.singletonMap((String)StringUtils.defaultIfBlank((CharSequence)user2.getLanguage(), (CharSequence)defaultLanguage), List.of(email));
            }
        } else if (JCRProjectMember.MemberType.GROUP == newMember.getType() && (group = this._groupManager.getGroup(groupIdentity = newMember.getGroup())) != null && project != null) {
            List<User> newUsersInProject = this._projectMemberManager.getGroupUsersFromProject(group, project, (currentProject, identity) -> this._isGroupMemberNewToTheProject((Project)((Object)currentProject), (UserIdentity)identity, groupIdentity));
            return newUsersInProject.stream().map(user -> Pair.of((Object)user, (Object)user.getEmail())).filter(p -> StringUtils.isNotEmpty((CharSequence)((CharSequence)p.getRight()))).collect(Collectors.groupingBy(p -> (String)StringUtils.defaultIfBlank((CharSequence)((User)p.getLeft()).getLanguage(), (CharSequence)defaultLanguage), Collectors.mapping(Pair::getRight, Collectors.toList())));
        }
        return Map.of();
    }

    @Override
    protected I18nizableText getI18nSubject(Event event, Project project) {
        return new I18nizableText("plugin." + this._pluginName, "PROJECT_MAIL_NOTIFICATION_EVENT_SUBJECT_MEMBER_ADDED", List.of(project.getTitle()));
    }

    @Override
    protected String getMailBodyURI(Event event, Project project) {
        return "cocoon://_plugins/workspaces/notification-mail-member-event";
    }

    private boolean _isGroupMemberNewToTheProject(Project project, UserIdentity userIdentity, GroupIdentity newGroupToIgnore) {
        Set<ProjectMemberManager.ProjectMember> projectMembers = this._projectMemberManager.getProjectMembers(project, false);
        boolean isUserOfProject = projectMembers.stream().filter(member -> JCRProjectMember.MemberType.USER == member.getType()).map(ProjectMemberManager.ProjectMember::getUser).map(User::getIdentity).filter(arg_0 -> ((UserIdentity)userIdentity).equals(arg_0)).findAny().isPresent();
        if (isUserOfProject) {
            return false;
        }
        return this._isUserMemberInAGroupMember(userIdentity, newGroupToIgnore, projectMembers);
    }

    private boolean _isUserMemberNewToProject(UserIdentity userIdentity, Project project) {
        Set<ProjectMemberManager.ProjectMember> projectMembers = this._projectMemberManager.getProjectMembers(project, false);
        return this._isUserMemberInAGroupMember(userIdentity, null, projectMembers);
    }

    private boolean _isUserMemberInAGroupMember(UserIdentity userIdentity, GroupIdentity newGroupToIgnore, Set<ProjectMemberManager.ProjectMember> projectMembers) {
        return projectMembers.stream().filter(member -> JCRProjectMember.MemberType.GROUP == member.getType()).map(ProjectMemberManager.ProjectMember::getGroup).filter(group -> newGroupToIgnore == null || !newGroupToIgnore.equals((Object)group.getIdentity())).filter(Objects::nonNull).map(Group::getUsers).flatMap(Collection::stream).filter(arg_0 -> ((UserIdentity)userIdentity).equals(arg_0)).findAny().isEmpty();
    }
}

