/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.rights;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.core.right.Profile;
import org.ametys.core.right.RightManager;
import org.ametys.core.right.RightProfilesDAO;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workspaces.WorkspacesHelper;
import org.ametys.plugins.workspaces.about.AboutWorkspaceModule;
import org.ametys.plugins.workspaces.alert.AlertWorkspaceModule;
import org.ametys.plugins.workspaces.calendars.CalendarWorkspaceModule;
import org.ametys.plugins.workspaces.documents.DocumentWorkspaceModule;
import org.ametys.plugins.workspaces.members.MembersWorkspaceModule;
import org.ametys.plugins.workspaces.minisite.MiniSiteWorkspaceModule;
import org.ametys.plugins.workspaces.news.NewsWorkspaceModule;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModule;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.wall.WallContentModule;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.DeferredServiceable;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.annotation.Obsolete;

public class ProjectRightHelper
extends AbstractLogEnabled
implements DeferredServiceable,
Component {
    public static final String ROLE = ProjectRightHelper.class.getName();
    @Obsolete
    private static final String __PROJECT_RIGHT_PROFILE = "PROJECT";
    protected AmetysObjectResolver _resolver;
    protected ProjectManager _projectManager;
    protected RightManager _rightManager;
    protected RightProfilesDAO _rightProfilesDao;
    protected CurrentUserProvider _currentUserProvider;
    protected WorkspaceModuleExtensionPoint _workspaceModuleEP;
    protected Map<String, WorkspaceModule> _contentTypesToModule;
    protected WorkspaceModuleExtensionPoint _moduleManagerEP;
    protected WorkspacesHelper _workspaceHelper;
    private Set<String> _profileIds;

    public void deferredService(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._rightProfilesDao = (RightProfilesDAO)manager.lookup(RightProfilesDAO.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._moduleManagerEP = (WorkspaceModuleExtensionPoint)((Object)manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._workspaceHelper = (WorkspacesHelper)((Object)manager.lookup(WorkspacesHelper.ROLE));
        this._workspaceModuleEP = (WorkspaceModuleExtensionPoint)((Object)manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._contentTypesToModule = Map.of("org.ametys.plugins.workspaces.Content.wallContent", this._workspaceModuleEP.getModule(WallContentModule.WALLCONTENT_MODULE_ID), "org.ametys.plugins.workspaces.Content.projectNews", this._workspaceModuleEP.getModule(NewsWorkspaceModule.NEWS_MODULE_ID), "org.ametys.plugins.workspaces.Content.alert", this._workspaceModuleEP.getModule(AlertWorkspaceModule.ALERT_MODULE_ID), "org.ametys.plugins.workspaces.Content.projectArticle", this._workspaceModuleEP.getModule(MiniSiteWorkspaceModule.MINISITE_MODULE_ID), "org.ametys.plugins.workspaces.Content.about", this._workspaceModuleEP.getModule(AboutWorkspaceModule.ABOUT_MODULE_ID));
    }

    public Map<String, WorkspaceModule> getProjectContentTypesAndModules() {
        return this._contentTypesToModule;
    }

    public synchronized Set<String> getProfilesIds() {
        if (this._profileIds == null) {
            String rawProjectProfileIds = StringUtils.defaultString((String)((String)Config.getInstance().getValue("workspaces.profile.list")));
            this._profileIds = Arrays.stream(StringUtils.split((String)rawProjectProfileIds, (char)',')).collect(Collectors.toSet());
        }
        return this._profileIds;
    }

    public Set<Profile> getProfiles() {
        Map<String, Profile> profileMap = this._rightProfilesDao.getProfiles(null).stream().collect(Collectors.toMap(Profile::getId, item -> item));
        return this.getProfilesIds().stream().map(id -> {
            Profile p = (Profile)profileMap.get(id);
            if (p == null) {
                this.getLogger().warn("Could not find profile with id '{}'.", id);
            }
            return p;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Callable(rights={""})
    public Map<String, Object> getProjectRightsData(String projectName) {
        Project project;
        Project project2 = project = projectName != null ? this._projectManager.getProject(projectName) : null;
        if (!this.canEditMember(project)) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to do read operation without convenient right");
        }
        List profiles = this.getProfiles().stream().map(this::_getProfileRightData).collect(Collectors.toList());
        Stream<Map> stream = this._moduleManagerEP.getExtensionsIds().stream().map(moduleId -> (WorkspaceModule)this._moduleManagerEP.getExtension((String)moduleId)).map(module -> this._getModuleRightData(project, (WorkspaceModule)module));
        List modules = stream.filter(Objects::nonNull).collect(Collectors.toList());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("profiles", profiles);
        result.put("modules", modules);
        return result;
    }

    private Map<String, Object> _getProfileRightData(Profile profile) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", profile.getId());
        data.put("label", profile.getLabel());
        return data;
    }

    private Map<String, Object> _getModuleRightData(Project project, WorkspaceModule module) {
        if (project != null && !this._projectManager.isModuleActivated(project, module.getId())) {
            return null;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", module.getId());
        data.put("label", module.getModuleTitle());
        return data;
    }

    public boolean canViewMembers(Project project) {
        return this._rightManager.currentUserHasReadAccess((Object)project);
    }

    public boolean canAddMember(Project project) {
        MembersWorkspaceModule module = (MembersWorkspaceModule)this._moduleManagerEP.getModule(MembersWorkspaceModule.MEMBERS_MODULE_ID);
        if (project != null && module != null && this._projectManager.isModuleActivated(project, module.getId())) {
            ModifiableResourceCollection moduleRoot = module.getModuleRoot(project, false);
            return moduleRoot != null && this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Service_Module_Members_Add", (Object)moduleRoot) == RightManager.RightResult.RIGHT_ALLOW;
        }
        return false;
    }

    public boolean canEditMember(Project project) {
        return this.canAddMember(project);
    }

    public boolean canRemoveMember(Project project) {
        return this._hasRightOnMembers(project, "Plugins_Workspaces_Rights_Service_Module_Members_Remove");
    }

    private boolean _hasRightOnMembers(Project project, String rightId) {
        MembersWorkspaceModule module = (MembersWorkspaceModule)this._moduleManagerEP.getModule(MembersWorkspaceModule.MEMBERS_MODULE_ID);
        if (module != null && this._projectManager.isModuleActivated(project, module.getId())) {
            ModifiableResourceCollection moduleRoot = module.getModuleRoot(project, false);
            return moduleRoot != null && this._rightManager.currentUserHasRight(rightId, (Object)moduleRoot) == RightManager.RightResult.RIGHT_ALLOW;
        }
        return false;
    }

    public boolean canAddTag(Project project) {
        return this._hasRightOnTagsOrPlaces(project, "Plugins_Workspaces_Rights_Project_Add_Tag");
    }

    public boolean canRemoveTag(Project project) {
        return this._hasRightOnTagsOrPlaces(project, "Plugins_Workspaces_Rights_Project_Delete_Tag");
    }

    private boolean _hasRightOnTagsOrPlaces(Project project, String rightId) {
        ModifiableResourceCollection moduleRoot;
        Object module = this._moduleManagerEP.getModule(CalendarWorkspaceModule.CALENDAR_MODULE_ID);
        if (module != null && this._projectManager.isModuleActivated(project, module.getId()) && (moduleRoot = module.getModuleRoot(project, false)) != null && this._rightManager.currentUserHasRight(rightId, (Object)moduleRoot) == RightManager.RightResult.RIGHT_ALLOW) {
            return true;
        }
        module = this._moduleManagerEP.getModule(DocumentWorkspaceModule.DOCUMENT_MODULE_ID);
        return module != null && this._projectManager.isModuleActivated(project, module.getId()) && (moduleRoot = module.getModuleRoot(project, false)) != null && this._rightManager.currentUserHasRight(rightId, (Object)moduleRoot) == RightManager.RightResult.RIGHT_ALLOW;
    }

    public boolean hasReadAccessOnModule(String moduleId) {
        return this.hasReadAccessOnModule(this._workspaceHelper.getProjectFromRequest(), moduleId);
    }

    public boolean hasReadAccessOnModule(Project project, String moduleId) {
        return this.hasReadAccessOnModule(project, moduleId, this._currentUserProvider.getUser());
    }

    public boolean hasReadAccessOnModule(Project project, String moduleId, UserIdentity userIdentity) {
        ModifiableResourceCollection moduleRoot;
        Object module = this._workspaceModuleEP.getModule(moduleId);
        if (module != null && project != null && (moduleRoot = module.getModuleRoot(project, false)) != null) {
            return this._rightManager.hasReadAccess(userIdentity, (Object)moduleRoot);
        }
        return false;
    }

    public boolean hasRightOnModule(String rightId, String moduleId) {
        return this.hasRightOnModule(this._workspaceHelper.getProjectFromRequest(), rightId, moduleId);
    }

    public boolean hasRightOnModule(Project project, String rightId, String moduleId) {
        ModifiableResourceCollection moduleRoot;
        Object module = this._workspaceModuleEP.getModule(moduleId);
        if (module != null && project != null && (moduleRoot = module.getModuleRoot(project, false)) != null) {
            return this._rightManager.currentUserHasRight(rightId, (Object)moduleRoot) == RightManager.RightResult.RIGHT_ALLOW;
        }
        return false;
    }

    public boolean hasRight(String rightId, Project project) {
        return this._rightManager.hasRight(this._currentUserProvider.getUser(), rightId, (Object)project) == RightManager.RightResult.RIGHT_ALLOW;
    }

    public boolean hasReadAccess() {
        return this.hasReadAccess(this._workspaceHelper.getProjectFromRequest());
    }

    public boolean hasReadAccess(Project project) {
        return project != null && this._rightManager.hasReadAccess(this._currentUserProvider.getUser(), (Object)project);
    }

    public boolean hasRight(String rightId, ExplorerNode explorerNode) {
        return this._rightManager.hasRight(this._currentUserProvider.getUser(), rightId, (Object)explorerNode) == RightManager.RightResult.RIGHT_ALLOW;
    }

    public boolean hasCatalogReadAccess(ZoneItem zoneItem) {
        SitemapElement sitemapElement = zoneItem.getZone().getSitemapElement();
        return this._isCatalogService(zoneItem) && this._rightManager.currentUserHasReadAccess((Object)sitemapElement);
    }

    private boolean _isCatalogService(ZoneItem zoneItem) {
        try {
            SitemapElement page = zoneItem.getZone().getSitemapElement();
            if (page.getSiteName().equals(this._projectManager.getCatalogSiteName())) {
                return zoneItem.getType() == ZoneItem.ZoneType.SERVICE && "org.ametys.plugins.workspaces.service.ProjectsCatalogue".equals(zoneItem.getServiceId());
            }
        }
        catch (ProjectManager.UnknownCatalogSiteException unknownCatalogSiteException) {
            // empty catch block
        }
        return false;
    }
}

