/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.rights.convertor;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.core.right.RightContextConvertor;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModule;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.project.rights.ProjectRightHelper;
import org.ametys.web.repository.content.WebContent;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ContentToModuleRightContextConvertor
implements RightContextConvertor,
Serviceable {
    protected ContentTypesHelper _cTypeHelper;
    protected ProjectManager _projectManager;
    protected ProjectRightHelper _projectRightHelper;
    private ServiceManager _manager;

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
    }

    protected synchronized ProjectRightHelper getProjectRightHelper() {
        if (this._projectRightHelper == null) {
            try {
                this._projectRightHelper = (ProjectRightHelper)((Object)this._manager.lookup(ProjectRightHelper.ROLE));
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._projectRightHelper;
    }

    protected synchronized ProjectManager getProjectManager() {
        if (this._projectManager == null) {
            try {
                this._projectManager = (ProjectManager)((Object)this._manager.lookup(ProjectManager.ROLE));
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._projectManager;
    }

    protected synchronized ContentTypesHelper getContentTypesHelper() {
        if (this._cTypeHelper == null) {
            try {
                this._cTypeHelper = (ContentTypesHelper)this._manager.lookup(ContentTypesHelper.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._cTypeHelper;
    }

    public Set<Object> convert(Object object) {
        Set<ResourceCollection> result = this._toModuleRoots(object);
        return result;
    }

    protected Set<ResourceCollection> _toModuleRoots(Object object) {
        WorkspaceModule module;
        if (object instanceof WebContent && (module = this._getWorkspaceModule((Content)object)) != null) {
            List<Project> projects = this.getProjectManager().getProjectsForSite(((WebContent)object).getSite());
            return projects.stream().map(p -> module.getModuleRoot((Project)((Object)p), false)).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return Collections.EMPTY_SET;
    }

    protected WorkspaceModule _getWorkspaceModule(Content content) {
        for (Map.Entry<String, WorkspaceModule> entry : this.getProjectRightHelper().getProjectContentTypesAndModules().entrySet()) {
            if (!this.getContentTypesHelper().isInstanceOf(content, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }
}

