/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.IgnoreRootHandler;
import org.ametys.plugins.workspaces.categories.Category;
import org.ametys.plugins.workspaces.categories.CategoryHelper;
import org.ametys.plugins.workspaces.categories.CategoryProviderExtensionPoint;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.search.SearchModule;
import org.ametys.plugins.workspaces.search.SearchModuleExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.impl.SitemapSource;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ModularSearchGenerator
extends ServiceableGenerator {
    protected SearchModuleExtensionPoint _searchModuleEP;
    protected SourceResolver _sourceResolver;
    protected ProjectManager _projectManager;
    protected CurrentUserProvider _currentUserProvider;
    protected ProjectMemberManager _projectMemberManager;
    protected CategoryProviderExtensionPoint _categoryProviderEP;
    protected CategoryHelper _categoryHelper;
    protected RightManager _rightManager;
    private WorkspaceModuleExtensionPoint _modulesEP;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._searchModuleEP = (SearchModuleExtensionPoint)((Object)smanager.lookup(SearchModuleExtensionPoint.ROLE));
        this._sourceResolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
        this._projectManager = (ProjectManager)((Object)smanager.lookup(ProjectManager.ROLE));
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._projectMemberManager = (ProjectMemberManager)((Object)smanager.lookup(ProjectMemberManager.ROLE));
        this._categoryProviderEP = (CategoryProviderExtensionPoint)((Object)smanager.lookup(CategoryProviderExtensionPoint.ROLE));
        this._categoryHelper = (CategoryHelper)smanager.lookup(CategoryHelper.ROLE);
        this._rightManager = (RightManager)smanager.lookup(RightManager.ROLE);
        this._modulesEP = (WorkspaceModuleExtensionPoint)((Object)smanager.lookup(WorkspaceModuleExtensionPoint.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        boolean withResults = this.parameters.getParameterAsBoolean("withResults", false);
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String moduleId = request.getParameter("moduleId");
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"search");
        this.saxFilters(request);
        if (moduleId != null) {
            SearchModule searchModule = (SearchModule)this._searchModuleEP.getExtension(moduleId);
            int offset = this.parameters.getParameterAsInteger("offset", 0);
            this.saxSearchModule(searchModule, withResults, offset);
        } else {
            List<Project> availableProjects = this.getAvailableProjects();
            this.saxProjects(availableProjects);
            this.saxCategories(availableProjects);
            this.saxSearchModules(availableProjects, withResults);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"search");
        this.contentHandler.endDocument();
    }

    protected void saxSearchModules(List<Project> availableProjects, boolean withResults) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"modules");
        List<SearchModule> searchModules = this._searchModuleEP.getExtensionsIds().stream().map(arg_0 -> ((SearchModuleExtensionPoint)this._searchModuleEP).getExtension(arg_0)).filter(s -> this.isSearchModuleAvailable((SearchModule)s, availableProjects)).sorted(Comparator.comparingInt(s -> s.getOrder())).toList();
        for (SearchModule searchModule : searchModules) {
            this.saxSearchModule(searchModule, withResults, 0);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"modules");
    }

    protected boolean isSearchModuleAvailable(SearchModule searchModule, List<Project> availableProjects) {
        String refModuleId = searchModule.getReferenceModuleId();
        if (refModuleId == null) {
            return true;
        }
        Object module = this._modulesEP.getModule(refModuleId);
        return availableProjects.stream().filter(project -> this._projectManager.isModuleActivated((Project)((Object)project), refModuleId)).filter(project -> this._rightManager.currentUserHasReadAccess((Object)module.getModuleRoot((Project)((Object)project), false))).findAny().isPresent();
    }

    protected void saxSearchModule(SearchModule searchModule, boolean withResults, int offset) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", searchModule.getId());
        attrs.addCDATAAttribute("url", searchModule.getSearchUrl());
        attrs.addCDATAAttribute("order", String.valueOf(searchModule.getOrder()));
        attrs.addCDATAAttribute("offset", String.valueOf(offset));
        attrs.addCDATAAttribute("limit", String.valueOf(searchModule.getLimit()));
        attrs.addCDATAAttribute("minLimit", String.valueOf(searchModule.getMinLimit()));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"module", (Attributes)attrs);
        searchModule.getTitle().toSAX(this.contentHandler, "title");
        if (withResults) {
            this.saxSearchModuleResults(searchModule, offset);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"module");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saxSearchModuleResults(SearchModule searchModule, int offset) {
        SitemapSource src = null;
        try {
            String uri = "cocoon://" + searchModule.getSearchUrl();
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            params.put("offset", offset);
            params.put("limit", searchModule.getLimit());
            params.put("minLimit", searchModule.getMinLimit());
            src = (SitemapSource)this._sourceResolver.resolveURI(uri, null, params);
            src.toSAX((ContentHandler)new IgnoreRootHandler(this.contentHandler));
            this._sourceResolver.release((Source)src);
        }
        catch (IOException | SAXException e) {
            this.getLogger().error("The search failed for module '" + searchModule.getId() + "'", (Throwable)e);
        }
        finally {
            this._sourceResolver.release(src);
        }
    }

    protected List<Project> getAvailableProjects() {
        UserIdentity user = this._currentUserProvider.getUser();
        Function<Project, String> getProjectTitle = Project::getTitle;
        Comparator<Project> projectTitleComparator = Comparator.comparing(getProjectTitle.andThen(StringUtils::stripAccents), String.CASE_INSENSITIVE_ORDER);
        return this._projectManager.getUserProjects(user).keySet().stream().sorted(projectTitleComparator).collect(Collectors.toList());
    }

    protected void saxFilters(Request request) throws SAXException {
        String[] projects;
        String[] categories;
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"filters");
        String textfield = request.getParameter("textfield");
        if (StringUtils.isNotBlank((CharSequence)textfield)) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"textfield", (String)textfield);
        }
        if ((categories = request.getParameterValues("category")) != null) {
            for (String category : categories) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"category", (String)category);
            }
        }
        if ((projects = request.getParameterValues("project")) != null) {
            for (String project : projects) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"project", (String)project);
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"filters");
    }

    protected void saxProjects(List<Project> projects) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"projects");
        for (Project project : projects) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", project.getId());
            attrs.addCDATAAttribute("name", project.getName());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"project", (Attributes)attrs, (String)project.getTitle());
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"projects");
    }

    protected void saxCategories(List<Project> projects) throws SAXException {
        Set rootCategories = projects.stream().map(Project::getCategories).flatMap(Collection::stream).map(id -> (Category)this._categoryProviderEP.getTag((String)id, null)).filter(Objects::nonNull).map(c -> this._getRootCategory((Category)c)).collect(Collectors.toSet());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"categories");
        for (Category category : rootCategories) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", category.getId());
            attrs.addCDATAAttribute("name", category.getName());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"category", (Attributes)attrs);
            Map<String, String> colors = this._categoryHelper.getCategoryColor(category);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"color", (String)colors.get("main"));
            category.getTitle().toSAX(this.contentHandler, "title");
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"category");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"categories");
    }

    private Category _getRootCategory(Category category) {
        Category parent = category;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return parent;
    }
}

