/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.search.module;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.query.SortCriteria;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.FullTextExpression;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.workspaces.calendars.Calendar;
import org.ametys.plugins.workspaces.calendars.CalendarColorsComponent;
import org.ametys.plugins.workspaces.calendars.CalendarWorkspaceModule;
import org.ametys.plugins.workspaces.calendars.events.CalendarEvent;
import org.ametys.plugins.workspaces.calendars.events.CalendarEventOccurrence;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.search.module.AbstractXpathSearchModuleGenerator;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class EventSearchModuleGenerator
extends AbstractXpathSearchModuleGenerator {
    protected CalendarWorkspaceModule _calendarModule;
    protected CalendarColorsComponent _calendarColors;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        WorkspaceModuleExtensionPoint moduleManagerEP = (WorkspaceModuleExtensionPoint)((Object)this.manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._calendarModule = (CalendarWorkspaceModule)moduleManagerEP.getModule(CalendarWorkspaceModule.CALENDAR_MODULE_ID);
        this._calendarColors = (CalendarColorsComponent)smanager.lookup(CalendarColorsComponent.ROLE);
    }

    @Override
    protected String getXPathQuery(String siteName, String lang, String textfield, Request request, int offset, int limit) throws Exception {
        List<Project> projects = this.getProjects(request, true);
        List<Project> filteredProjects = this.filterProjectsForModule(projects, CalendarWorkspaceModule.CALENDAR_MODULE_ID);
        if (filteredProjects.isEmpty()) {
            return null;
        }
        String projectXPathQuery = this.getProjectXPathQuery(filteredProjects);
        Object searchQuery = "";
        if (StringUtils.isNotBlank((CharSequence)textfield)) {
            FullTextExpression titleExpr = new FullTextExpression("title", textfield);
            FullTextExpression descExpr = new FullTextExpression("description", textfield);
            OrExpression expr = new OrExpression(new Expression[]{titleExpr, descExpr});
            searchQuery = "[" + expr.build() + "]";
        }
        SortCriteria sortCriteria = new SortCriteria();
        sortCriteria.addCriterion("startDate", false, false);
        String sortQuery = sortCriteria.build();
        String jcrQuery = projectXPathQuery + "//element(*, ametys:calendar-event)" + (String)searchQuery + " " + sortQuery;
        return jcrQuery;
    }

    @Override
    protected void saxHit(AmetysObject object, String lang) throws Exception {
        if (object instanceof CalendarEvent) {
            CalendarEvent calendarEvent = (CalendarEvent)object;
            Project project = this.getProject(object);
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", calendarEvent.getId());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"hit", (Attributes)attrs);
            String eventUri = this._calendarModule.getEventUri(project, calendarEvent.getParent().getId(), calendarEvent.getId());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"uri", (String)eventUri);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title", (String)calendarEvent.getTitle());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"fullDay", (String)String.valueOf(calendarEvent.getFullDay()));
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"creationDate", (String)DateUtils.zonedDateTimeToString((ZonedDateTime)calendarEvent.getCreationDate()));
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"startDate", (String)DateUtils.zonedDateTimeToString((ZonedDateTime)calendarEvent.getStartDate()));
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"endDate", (String)DateUtils.zonedDateTimeToString((ZonedDateTime)calendarEvent.getEndDate()));
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"recurrenceType", (String)calendarEvent.getRecurrenceType().name().toLowerCase());
            Optional<CalendarEventOccurrence> nextOccurrence = calendarEvent.getNextOccurrence(new CalendarEventOccurrence(calendarEvent, ZonedDateTime.now()));
            if (nextOccurrence.isPresent()) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"nextOccurence", (String)DateUtils.zonedDateTimeToString((ZonedDateTime)nextOccurrence.get().getStartDate()));
            }
            if (calendarEvent.getDescription() != null) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"description", (String)calendarEvent.getDescription());
            }
            if (calendarEvent.getLocation() != null) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"location", (String)calendarEvent.getLocation());
            }
            this.saxUser(calendarEvent.getCreator(), "creator");
            this.saxProject(project);
            this.saxCalendar(this.getCalendar(calendarEvent));
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"hit");
        }
    }

    protected Calendar getCalendar(CalendarEvent event) {
        for (AmetysObject parent = event.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Calendar)) continue;
            return (Calendar)parent;
        }
        return null;
    }

    protected void saxCalendar(Calendar calendar) throws SAXException {
        if (calendar != null) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", calendar.getId());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"calendar", (Attributes)attrs);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title", (String)calendar.getName());
            CalendarColorsComponent.CalendarColor color = this._calendarColors.getColor(calendar.getColor());
            if (color != null) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"color", (String)color.getColor());
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"textColor", (String)color.getTextColor());
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"calendar");
        }
    }
}

