/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.search.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.ametys.cms.search.query.Query;
import org.ametys.cms.search.query.QuerySyntaxException;

public class ProjectQuery
implements Query {
    private Query.Operator _operator;
    private List<String> _ids;

    public ProjectQuery() {
        this(Query.Operator.EQ, "*");
    }

    public ProjectQuery(String ... ids) {
        this(Query.Operator.EQ, ids);
    }

    public ProjectQuery(Collection<String> ids) {
        this(Query.Operator.EQ, ids);
    }

    public ProjectQuery(Query.Operator operator, String ... ids) {
        this(operator, Arrays.asList(ids));
    }

    public ProjectQuery(Query.Operator operator, Collection<String> ids) {
        if (Query.Operator.EQ != operator && Query.Operator.NE != operator) {
            throw new IllegalArgumentException("Test operator '" + String.valueOf(operator) + "' is unknown for test's expression.");
        }
        this._operator = operator;
        this._ids = new ArrayList<String>(ids);
    }

    public String build() throws QuerySyntaxException {
        int count = this._ids.size();
        StringBuilder sb = new StringBuilder();
        if (this._operator == Query.Operator.NE) {
            sb.append('-');
        }
        if (count > 1) {
            sb.append('(');
        }
        boolean first = true;
        for (String id : this._ids) {
            if (!first) {
                sb.append(" OR ");
            }
            sb.append("workspace-projectId").append(":\"").append(id).append("\"");
            first = false;
        }
        if (count > 1) {
            sb.append(')');
        }
        return sb.toString();
    }
}

