/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.signup;

import com.google.common.collect.Multimap;
import java.util.List;
import org.ametys.core.user.User;
import org.ametys.plugins.workspaces.members.ProjectInvitationHelper;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.Page;
import org.ametys.web.usermanagement.UserManagementException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class UserSignupManager
extends org.ametys.plugins.userdirectory.signup.UserSignupManager {
    private ProjectManager _projectManager;
    private ProjectInvitationHelper _invitationHelper;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._projectManager = (ProjectManager)((Object)serviceManager.lookup(ProjectManager.ROLE));
        this._invitationHelper = (ProjectInvitationHelper)((Object)serviceManager.lookup(ProjectInvitationHelper.ROLE));
    }

    public void temporarySignup(String siteName, String language, String email, String population, String userDirectoryId) throws UserManagementException {
        String signupSiteName = this._getSignupSiteName(siteName);
        boolean sendMail = signupSiteName.equals(siteName);
        super.temporarySignup(signupSiteName, language, email, population, userDirectoryId, sendMail);
    }

    public void additionalSignupOperations(User createdUser, Multimap<String, I18nizableText> errors) throws UserManagementException {
        super.additionalSignupOperations(createdUser, errors);
        this._invitationHelper.createMemberFromInvitations(createdUser);
    }

    public boolean isPublicSignupAllowed(String siteName) {
        return super.isPublicSignupAllowed(this._getSignupSiteName(siteName));
    }

    public Page getSignupPage(String siteName, String language) {
        return super.getSignupPage(this._getSignupSiteName(siteName), language);
    }

    public List<Page> getSignupPages(String siteName, String language) {
        return super.getSignupPages(this._getSignupSiteName(siteName), language);
    }

    public Page getPwdChangePage(String siteName, String language) {
        return super.getPwdChangePage(this._getSignupSiteName(siteName), language);
    }

    public List<Page> getPwdChangePages(String siteName, String language) {
        return super.getPwdChangePages(this._getSignupSiteName(siteName), language);
    }

    private String _getSignupSiteName(String siteName) {
        String signupSite = siteName;
        List<String> projectNames = this._projectManager.getProjectsForSite(siteName);
        if (!projectNames.isEmpty()) {
            signupSite = this._projectManager.getCatalogSiteName();
        }
        return signupSite;
    }
}

