/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.tags;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.cms.tag.AbstractTagProvider;
import org.ametys.cms.tag.CMSTag;
import org.ametys.cms.tag.DefaultTag;
import org.ametys.cms.tag.TagTargetType;
import org.ametys.cms.tag.TagTargetTypeExtensionPoint;
import org.ametys.plugins.workspaces.tags.ProjectCMSTag;
import org.ametys.plugins.workspaces.tags.ProjectJCRTagProvider;
import org.ametys.plugins.workspaces.tags.ProjectTagProviderExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class ProjectCMSTagProvider
extends AbstractTagProvider<CMSTag>
implements Serviceable {
    protected TagTargetTypeExtensionPoint _targetTypeEP;
    protected ProjectTagProviderExtensionPoint _projectTagProviderEP;
    protected ProjectJCRTagProvider _jcrProjectTagProvider;

    public void service(ServiceManager smanager) throws ServiceException {
        this._targetTypeEP = (TagTargetTypeExtensionPoint)smanager.lookup(TagTargetTypeExtensionPoint.ROLE);
        this._projectTagProviderEP = (ProjectTagProviderExtensionPoint)((Object)smanager.lookup(ProjectTagProviderExtensionPoint.ROLE));
        this._jcrProjectTagProvider = (ProjectJCRTagProvider)((Object)this._projectTagProviderEP.getExtension(ProjectJCRTagProvider.class.getName()));
    }

    public Map<String, CMSTag> getTags(Map<String, Object> contextualParameters) {
        HashMap<String, CMSTag> cmsTags = new HashMap<String, CMSTag>();
        Map projectTags = this._jcrProjectTagProvider.getTags(contextualParameters);
        for (Map.Entry projectTag : projectTags.entrySet()) {
            ProjectCMSTag cmsTag = this._transformToCMSTag((DefaultTag)projectTag.getValue(), contextualParameters);
            cmsTags.put(cmsTag.getId(), this._transformToCMSTag((DefaultTag)projectTag.getValue(), contextualParameters));
        }
        return cmsTags;
    }

    public CMSTag getTag(String tagName, Map<String, Object> contextualParameters) {
        String projectTagName = tagName;
        if (projectTagName.startsWith("WORKSPACES_TAG_")) {
            projectTagName = StringUtils.substringAfter((String)tagName, (String)"WORKSPACES_TAG_");
            return this._transformToCMSTag((DefaultTag)this._jcrProjectTagProvider.getTag(projectTagName, contextualParameters), contextualParameters);
        }
        return null;
    }

    public Collection<CMSTag> getTags(String tagName, Map<String, Object> contextualParameters) {
        String projectTagName = tagName;
        if (projectTagName.startsWith("WORKSPACES_TAG_")) {
            projectTagName = StringUtils.substringAfter((String)tagName, (String)"WORKSPACES_TAG_");
            Collection<DefaultTag> projectTags = this._jcrProjectTagProvider.getTags(projectTagName, contextualParameters);
            return projectTags.stream().map(tag -> this._transformToCMSTag((DefaultTag)tag, contextualParameters)).collect(Collectors.toList());
        }
        return List.of();
    }

    public boolean hasTag(String tagName, Map<String, Object> contextualParameters) {
        String projectTagName = tagName;
        if (projectTagName.startsWith("WORKSPACES_TAG_")) {
            projectTagName = StringUtils.substringAfter((String)tagName, (String)"WORKSPACES_TAG_");
            return this._jcrProjectTagProvider.hasTag(projectTagName, contextualParameters);
        }
        return false;
    }

    protected ProjectCMSTag _transformToCMSTag(DefaultTag projectTag, Map<String, Object> contextualParameters) {
        if (projectTag != null) {
            CMSTag parentTag = null;
            DefaultTag parentProjectTag = projectTag.getParent();
            if (parentProjectTag != null) {
                parentTag = this.getTag(parentProjectTag.getName(), contextualParameters);
            }
            TagTargetType targetType = this._targetTypeEP.getTagTargetType("CONTENT");
            return new ProjectCMSTag(projectTag, parentTag, targetType);
        }
        return null;
    }
}

