/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.util;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.cms.content.RichTextHandler;
import org.ametys.cms.data.Binary;
import org.ametys.cms.data.RichText;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ReactionableObject;
import org.ametys.cms.repository.comment.AbstractComment;
import org.ametys.cms.repository.comment.Comment;
import org.ametys.cms.repository.comment.CommentsDAO;
import org.ametys.cms.repository.comment.RichTextComment;
import org.ametys.cms.transformation.RichTextTransformer;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.tag.TaggableAmetysObject;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.tags.ProjectTagProviderExtensionPoint;
import org.ametys.plugins.workspaces.util.ThreadDocbookTransformer;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class WorkspaceObjectJSONHelper
extends AbstractLogEnabled
implements Serviceable {
    public static final String ATTRIBUTE_FOR_RICHTEXT_ERROR = "contentError";
    protected UserHelper _userHelper;
    protected ProjectTagProviderExtensionPoint _tagProviderExtensionPoint;
    protected ProjectMemberManager _projectMemberManager;
    protected UserManager _userManager;
    protected CurrentUserProvider _currentUserProvider;
    protected PopulationContextHelper _populationContextHelper;
    protected SourceResolver _sourceResolver;
    protected RichTextTransformer _richTextTransformer;
    protected ServiceManager _smanager;
    protected CommentsDAO _commentsDAO;

    public void service(ServiceManager manager) throws ServiceException {
        this._smanager = manager;
        this._userHelper = (UserHelper)manager.lookup(UserHelper.ROLE);
        this._tagProviderExtensionPoint = (ProjectTagProviderExtensionPoint)((Object)manager.lookup(ProjectTagProviderExtensionPoint.ROLE));
        this._projectMemberManager = (ProjectMemberManager)((Object)manager.lookup(ProjectMemberManager.ROLE));
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._populationContextHelper = (PopulationContextHelper)manager.lookup(PopulationContextHelper.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._richTextTransformer = (RichTextTransformer)manager.lookup(ThreadDocbookTransformer.ROLE);
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._commentsDAO = (CommentsDAO)manager.lookup(CommentsDAO.ROLE);
    }

    protected <T extends AbstractComment> List<Map<String, Object>> _commentsToJson(List<T> comments, String lang, String siteName) {
        return this._commentsToJson(comments, lang, siteName, null, true);
    }

    protected <T extends AbstractComment> List<Map<String, Object>> _commentsToJson(List<T> comments, String lang, String siteName, ZonedDateTime lastReadDate, boolean parseCommentcontent) {
        ArrayList<Map<String, Object>> json = new ArrayList<Map<String, Object>>();
        for (AbstractComment comment : comments) {
            json.add(this._commentToJson(comment, lang, siteName, lastReadDate, parseCommentcontent));
        }
        return json;
    }

    /*
     * Exception decompiling
     */
    public String richTextToRendering(RichText content) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String richTextToSimpleText(RichText richText, int maxLength) {
        String string;
        InputStream is;
        SAXParser saxParser;
        block10: {
            saxParser = null;
            is = richText.getInputStream();
            RichTextHandler txtHandler = new RichTextHandler(maxLength);
            saxParser = (SAXParser)this._smanager.lookup(SAXParser.ROLE);
            saxParser.parse(new InputSource(is), (ContentHandler)txtHandler);
            string = txtHandler.getValue();
            if (is == null) break block10;
            is.close();
        }
        this._smanager.release((Object)saxParser);
        return string;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        this.getLogger().error("Cannot extract simple text from richtext", (Throwable)e);
                        this._smanager.release(saxParser);
                    }
                }
                catch (Throwable throwable3) {
                    this._smanager.release(saxParser);
                    throw throwable3;
                }
            }
        }
        return "";
    }

    protected <T extends AbstractComment> Map<String, Object> _commentToJson(T comment, String lang, String siteName, ZonedDateTime lastReadDate, boolean parseCommentcontent) {
        RichTextComment richTextComment;
        HashMap<String, Object> commentJson = new HashMap<String, Object>();
        commentJson.put("id", comment.getId());
        commentJson.put("subComments", this._commentsToJson(comment.getSubComment(true, true), lang, siteName));
        commentJson.put("isDeleted", comment.isDeleted());
        commentJson.put("creationDate", comment.getCreationDate());
        commentJson.put("isReported", comment.getReportsCount() > 0L);
        if (comment.isSubComment()) {
            AbstractComment parent = comment.getCommentParent();
            commentJson.put("parentId", parent.getId());
            User author = this._userManager.getUser(parent.getAuthor());
            commentJson.put("parentAuthor", this._authorToJSON(parent, author, lang));
        }
        if (!comment.isDeleted()) {
            commentJson.put("text", comment.getContent());
            if (comment instanceof Comment) {
                Comment mentionComment = (Comment)comment;
                List<Map> mentionedUsers2json = mentionComment.extractMentions().stream().map(user -> this._userHelper.user2json(user)).toList();
                commentJson.put("mentions", mentionedUsers2json);
            }
            commentJson.put("isEdited", comment.isEdited());
            commentJson.put("nbLike", comment.getReactionUsers(ReactionableObject.ReactionType.LIKE).size());
            List userLikes = comment.getReactionUsers(ReactionableObject.ReactionType.LIKE).stream().map(UserIdentity::userIdentityToString).collect(Collectors.toList());
            commentJson.put("userLikes", userLikes);
            commentJson.put("accepted", comment.isAccepted());
            UserIdentity currentUser = this._currentUserProvider.getUser();
            commentJson.put("isLiked", userLikes.contains(UserIdentity.userIdentityToString((UserIdentity)currentUser)));
            User author = this._userManager.getUser(comment.getAuthor());
            commentJson.put("author", this._authorToJSON(comment, author, lang));
            commentJson.put("canHandle", author != null ? author.getIdentity().equals((Object)currentUser) : false);
        }
        if (lastReadDate != null && comment.getCreationDate().isAfter(lastReadDate)) {
            commentJson.put("unread", true);
        }
        if (comment instanceof RichTextComment && (richTextComment = (RichTextComment)comment).hasRichTextContent() && parseCommentcontent) {
            RichText richText = richTextComment.getRichTextContent();
            StringBuilder result = new StringBuilder(2048);
            try {
                this._richTextTransformer.transformForEditing(richText, DataContext.newInstance(), result);
                commentJson.put("contentEditing", result.toString());
                commentJson.put("contentRendering", this.richTextToRendering(richText));
            }
            catch (IOException | AmetysRepositoryException e) {
                commentJson.put(ATTRIBUTE_FOR_RICHTEXT_ERROR, true);
                this.getLogger().error("Unable to transform the rich text value into a string", e);
            }
        }
        return commentJson;
    }

    protected <T extends AbstractComment> Map<String, Object> _authorToJSON(T comment, User author, String lang) {
        HashMap<String, Object> jsonAuthor = new HashMap<String, Object>();
        jsonAuthor.put("name", Optional.ofNullable(author).map(User::getFullName).orElse(comment.getAuthorName()));
        if (author != null) {
            UserIdentity userIdentity = author.getIdentity();
            jsonAuthor.put("id", UserIdentity.userIdentityToString((UserIdentity)userIdentity));
            jsonAuthor.put("login", userIdentity.getLogin());
            jsonAuthor.put("populationId", userIdentity.getPopulationId());
            Content member = this._projectMemberManager.getUserContent(lang, author);
            if (member != null) {
                if (member.hasValue("function")) {
                    jsonAuthor.put("function", member.getValue("function"));
                }
                if (member.hasValue("organisation-accronym")) {
                    jsonAuthor.put("organisationAcronym", member.getValue("organisation-accronym"));
                }
            }
        }
        return jsonAuthor;
    }

    protected Map<String, Object> _binaryToJson(Binary binary) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        try (InputStream is = binary.getInputStream();){
            json.put("id", binary.getFilename());
            json.put("name", binary.getFilename());
            json.put("type", binary.getMimeType());
            json.put("size", binary.getLength());
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred reading binary {}", (Object)binary.getFilename(), (Object)e);
        }
        return json;
    }

    protected List<String> _getTags(TaggableAmetysObject taggableAmetysObject, String siteName) {
        return taggableAmetysObject.getTags().stream().filter(tag -> this._tagProviderExtensionPoint.hasTag((String)tag, Map.of("siteName", siteName))).collect(Collectors.toList());
    }
}

