/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

let count = 0;

// Migrate 'editionFO' content types to 'about'
logger.info("Start migration of About contents");
migrateContentType("org.ametys.plugins.workspaces.Content.editionFO", "org.ametys.plugins.workspaces.Content.about");

function migrateContentType(oldContentTypeId, newContentTypeId)
{
    let query = "//element(*, ametys:content)[@ametys-internal:contentType = '" + oldContentTypeId + "']";
    
    Repository.query(query).forEach(function(content)             
    {      
        Content.migrate(             
            content,             
            [__migrateContentType.bind(null, newContentTypeId)],             
            false /* old versions are still compatible */,             
            null /* no tag */,             
            false /* not verbose */,
            true /* synchronize live */
        );             
    });     ;
    
    logger.info(`Content type ${oldContentTypeId} has been migrated to ${newContentTypeId} for ${count} content(s)`);
}

function __migrateContentType(newContentType, content)
{
    content.setType(newContentType);
    count++; 
}
