/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
let siteManager = Ametys.serviceManager.lookup(org.ametys.web.repository.site.SiteManager.ROLE);

let projectCount = 0;
let migratedProjectCount = 0;

let jcrQuery = "//element(*, ametys:project)";
Repository.query(jcrQuery, true, Repository.session).forEach(
    project =>
    {   
        projectCount++; 
        renameSitesInSite(project, "default session");
    }
);

logger.info(`${migratedProjectCount} project(s) have been migrated out of ${projectCount} project(s) in default session`);

projectCount = 0;
migratedProjectCount = 0;

Repository.query(jcrQuery, true, Repository.liveSession).forEach(
    project =>
    {   
        projectCount++; 
        renameSitesInSite(project, "live session");
    }
);

logger.info(`${migratedProjectCount} project(s) have been migrated out of ${projectCount} project(s) in live session`);

function renameSitesInSite(project, session) {
    let projectNode = project.getNode();
    
    // Check if sites node exists
    if (project.getNode().hasNode("ametys:sites"))
    {
        let sitesData = project.getNode().getNode("ametys:sites");
        
        if (sitesData.hasProperty("1"))
        {
            let siteNode;
            try 
            {
                siteNode = sitesData.getProperty("1").getNode();
            }
            catch
            {
                logger.warn("The project " + project.getName() + " is linked to an unexisting site in " + session);
                return;
            }
            
            // Sites only had one and only one site, get the first
            let siteName = siteNode.getName();
            
            let site = siteManager.getSite(siteName);
            project.setSite(site);
            project.removeValue("sites");
            if (project.needsSave())
            {
                migratedProjectCount++;
                project.saveChanges();
            }
        }
        else
        {
            logger.warn("The project " + project.getName() + " have no site in " + session);
        }
    }
    // If sites node does not exists, check if the project have already been migrated. If not, throw error.
    else if(!project.getNode().hasProperty("ametys:site"))
    {
        logger.warn("The project " + project.getName() + " have no sites node in " + session)
    }
}
