/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
try { logger; }
catch (e) { logger = Ametys.getLogger("org.ametys.core.migration.MigrationExtensionPoint.workspaces"); }

let projectManager = Ametys.serviceManager.lookup(org.ametys.plugins.workspaces.project.ProjectManager.ROLE);
  
var countProjects = 0;
var error = "";
  
projectManager.getProjects().forEach(function (project) 
{
  let site = project.getSite();
  let sitemapSize = site.getSitemaps().getSize();
  if (sitemapSize != 1)
  {
      countProjects++;
      error += "" + site.getName() + " (" + sitemapSize + " languages) ";
  }
});
  
if (countProjects == 0)
{
  logger.info("No error project(s) languages");
}
else
{
  throw new Error(countProjects + " project(s) have multilingual sitemaps that is not authorized anymore. Remove extra sitemaps in admin of the following sites and restart Ametys to process the migration. " + error)
}
