/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

let projectManager = Ametys.serviceManager.lookup(org.ametys.plugins.workspaces.project.ProjectManager.ROLE);
let workspaceModuleExtensionPoint = Ametys.serviceManager.lookup(org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint.ROLE);
let tagsEP = Ametys.serviceManager.lookup(org.ametys.plugins.workspaces.tags.ProjectTagProviderExtensionPoint.ROLE);
  
let count = 0;
let allTags = _getAllTagsName();
projectManager.getProjects().forEach(
    project =>
    {   
        count = 0;     
        logger.info("[Default] Start migrating keywords for resources in project " + project.getName())
        let module = workspaceModuleExtensionPoint.getModule(org.ametys.plugins.workspaces.documents.DocumentWorkspaceModule.DOCUMENT_MODULE_ID);
        let root = module.getModuleRoot(project, false)
        if (root != null)
        {
            _migrateFolder(root);
            logger.info("[Default] " + count  + " resources migrated");
            try 
            {
                count = 0;     
                logger.info("[Live] Start migrating keywords for resources in project " + project.getName())
                let rootLive = Repository.resolver.resolveById(root.getId(), Repository.liveSession);
                _migrateFolder(rootLive);
                logger.info("[Live] " + count  + " resources migrated");
            }
            catch (e) {/* No data in live */}
        }
    }
);
  
function _migrateFolder(document)
{
    for (let child of document.getChildren())
    {
        if (child instanceof org.ametys.plugins.explorer.resources.Resource)
        {
            _migrateKeywords(child);
        }
        else if (child instanceof org.ametys.plugins.explorer.resources.ResourceCollection)
        {
            _migrateFolder(child);
        }
    }
}
  
function _migrateKeywords(resource)
{
    let hasChanges = false;
    for (let keyword of resource.getKeywords())
    {
       let filteredName = java.text.Normalizer.normalize(keyword.toLowerCase(), java.text.Normalizer.Form.NFD).replaceAll("[\\p{InCombiningDiacriticalMarks}]", "").trim(); 
       let tagName = filteredName.replaceAll("œ", "oe").replaceAll("æ", "ae").replaceAll("[^a-z0-9]", "_").replaceAll("_+", "_").toUpperCase();
       if (_hasTag(tagName))
       {
          resource.tag(tagName);
          hasChanges = true;
       }
       else
       {
          _addTag(tagName, keyword);
          resource.tag(tagName);
          hasChanges = true;
          logger.info("Creating project tag " + keyword);
       }
    }
    
    if (resource.getNode().hasProperty("ametys:keywords"))
    {
        resource.getNode().getProperty("ametys:keywords").remove();
        hasChanges = true;
    }
    
    if (hasChanges)
    {
        resource.saveChanges();
        count++;
    }
}

function _hasTag(tagName)
{
    return allTags.indexOf(tagName) != -1;
}

function _getAllTagsName()
{
    let provider = tagsEP.getExtension("org.ametys.plugins.workspaces.tags.ProjectJCRTagProvider"); 
    let rootTag = provider.getRootNode(null);
    
    return _getTagsName(rootTag);
}
  
function _getTagsName(rootTag)
{
    let tagNames = [];
    for (let child of rootTag.getChildren())
    {
        if (child instanceof org.ametys.plugins.workspaces.tags.ProjectTagJCR)
        {
            tagNames.push(child.getName());
            for (let childTagName of _getTagsName(child))
            {
                tagNames.push(childTagName);
            }
        }
    }
    return tagNames;
}

function _addTag(tagName, tagTitle)
{
    let provider = tagsEP.getExtension("org.ametys.plugins.workspaces.tags.ProjectJCRTagProvider"); 
    let rootTag = provider.getRootNode(null);
    
    let jcrTag = rootTag.createChild(tagName, org.ametys.plugins.workspaces.tags.ProjectTagFactory.TAG_NODETYPE);
    jcrTag.setTitle(tagTitle);
    jcrTag.setDescription("");
    
    allTags.push(tagName);
        
    rootTag.saveChanges();
}
