/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

  transform(Repository.session);
  transform(Repository.liveSession);
  
  function transform(s)
  {
          Repository.query("//element(*, ametys:site)[@ametys:type='workspaces.project']", true, s).forEach(function(site) {
                site.getSitemaps().forEach(function(sitemap) {

                    sitemap.getChildrenPages().forEach(function(page) {
                        if (page.getName() == "index")
                        {
                            const zone = page.getZone("default");
                            if (zone)
                            {
                                zone.getZoneItems().forEach(function (zi) {
                                    if (zi.getType() == org.ametys.web.repository.page.ZoneItem.ZoneType.SERVICE
                                       && zi.getServiceId() == "org.ametys.web.service.SearchService")
                                    {
                                        const right = zi.getServiceParameters().setValue("rightCheckingMode", "none")
                                        zi.saveChanges();
                                    }
                                });
                            }                  
                        }
                    });
                });
          });
  }  