/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */


const rightsToMigrate = 
{
    "Plugin_Explorer_Calendar_Add" : "Plugins_Workspaces_Calendar_Add",
    "Plugin_Explorer_Calendar_Edit" : "Plugins_Workspaces_Calendar_Edit",
    "Plugin_Explorer_Calendar_Delete" : "Plugins_Workspaces_Calendar_Delete",
    
    "Plugin_Explorer_Event_Add" : "Plugins_Workspaces_Event_Add",
    "Plugin_Explorer_Event_Edit" : "Plugins_Workspaces_Event_Edit",
    "Plugin_Explorer_Event_Propose" : "Plugins_Workspaces_Event_Propose",
    "Plugin_Explorer_Event_Validate" : "Plugins_Workspaces_Event_Validate",
    "Plugin_Explorer_Event_Refuse" : "Plugins_Workspaces_Event_Refuse",
    "Plugin_Explorer_Event_Delete" : "Plugins_Workspaces_Event_Delete",
    "Plugin_Explorer_Owned_Event_Delete" : "Plugins_Workspaces_Owned_Event_Delete",
}
const _rightProfileDAO = Ametys.serviceManager.lookup("org.ametys.core.right.RightProfilesDAO");
profiles=_rightProfileDAO.getProfiles()
for(let profile of profiles)
{
    let profileRights = _rightProfileDAO.getRights(profile)
    for(let [oldRight, newRight] of Object.entries(rightsToMigrate))
    {
      if (profileRights.contains(oldRight))
      {
          _rightProfileDAO.removeRight(profile, oldRight, true);
          _rightProfileDAO.addRight(profile, newRight);
      }
    }
}
