<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:math="java.lang.Math"
                extension-element-prefixes="ametys math resolver">
                
    <xsl:import href="service:web://pages/services/common.xsl"/>
    
    <xsl:variable name="header" select="string(ametys:serviceParameter('header')/text())"/>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:variable name="maxMembers">3</xsl:variable>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">my-projects</xsl:variable>
    <xsl:variable name="common-service-name">service-my-projects</xsl:variable>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="projects-js"/>
        
        <script type="text/javascript">
            $j(document).ready(function(){
            
                Projects.open("#projects-<xsl:value-of select="$uniqueId"/>", function() {
                });
                
                // Projects is always visible
                AmetysFront.Event.fire("projects-opened");
            });
        </script>
        
    </xsl:template>
    
    <xsl:template name="projects-js">    
        <script type="text/javascript" src="{ametys:pluginResourceURL('workspaces', concat('js/projects.', ametys:lang(), '.js'))}"></script>
        
        <script type="text/javascript">
            <!-- For legacy purpose (4.7 compatibility)-->
            window.VEvent = AmetysFront.Event
            <!-- // END for legacy purpose -->
            
            Projects.configure('<xsl:value-of select="$site-uri-prefix"/>', '<xsl:value-of select="$site" />', '<xsl:value-of select="$lang" />', <xsl:value-of select="$maxMembers"/>);
        </script>
    </xsl:template>
    
    <!-- +
         | HEAD
         + -->   
    <!-- Used by common -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- +
         | BODY
         + -->
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-content">
    	<div id="projects-{$uniqueId}"> 
            <div data-ametys-projects-role="results" >
                <!-- Projects will be inserted here -->
            </div>
        </div>
    </xsl:template>
    
</xsl:stylesheet>
