<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2016 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="java.lang.Math"
                extension-element-prefixes="ametys math">
                
    <xsl:import href="service:web://pages/services/common.xsl"/>
    
    <xsl:variable name="header" select="string(ametys:serviceParameter('header')/text())"/>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">filtered-events</xsl:variable>
    <xsl:variable name="common-service-name">service-filtered-events</xsl:variable>
    
    <xsl:variable name="date-format" select="ametys:translate('plugin.workspaces:PLUGINS_WORKSPACES_SERVICE_SIMPLE_FILTERED_EVENTS_DATE_FORMAT')"></xsl:variable>
    <xsl:variable name="time-format" select="ametys:translate('plugin.workspaces:PLUGINS_WORKSPACES_SERVICE_SIMPLE_FILTERED_EVENTS_TIME_FORMAT')"></xsl:variable>
    
    <!-- +
         | HEAD
         + -->   
    <!-- Used by common -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- +
         | BODY
         + -->
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:choose>
        	<xsl:when test="event">
        		<xsl:call-template name="events"/>
        	</xsl:when>
        	<xsl:otherwise>
        		<xsl:call-template name="events-empty"/>
        	</xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="events-empty">
        <p><i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_SIMPLE_FILTERED_EVENTS_NO_RESULTS" /></p>
    </xsl:template>
    
    <xsl:template name="events">
    	<ul class="events">
        	<xsl:apply-templates select="event"/>
        </ul>
    </xsl:template>
    
    <xsl:template match="event">
        <li>
        	<xsl:attribute name="class"><xsl:call-template name="common-utils-class"/> event</xsl:attribute>
            <xsl:call-template name="event-date"/>
            <xsl:call-template name="event-project-title"/>
            <xsl:call-template name="event-calendar-title"/>
            <xsl:call-template name="event-title"/>
        </li>
    </xsl:template>
    
    <xsl:template name="event-date">
    	<div class="event-date">
    		<i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="{$date-format}" value="{startDate}"/>
    		<xsl:text> </xsl:text>
    		<i18n:date-time src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="{$time-format}" value="{startDate}"/>
         </div>
    </xsl:template>
    
    <xsl:template name="event-project-title">
        <div class="event-project-title"><xsl:value-of select="project" /></div>
    </xsl:template>

    <xsl:template name="event-calendar-title">
        <div class="event-calendar-title"><xsl:value-of select="calendar" /></div>
    </xsl:template>
    
    <xsl:template name="event-title">
    	<div class="event-title">
            <xsl:choose>
                <xsl:when test="eventUrl != ''">
                    <a href="{eventUrl}" target="_blank"><xsl:value-of select="title" /></a>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="title" />
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
</xsl:stylesheet>
