<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2016 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:math="java.lang.Math"
                xmlns:uriutils="org.ametys.core.util.URIUtils"
                extension-element-prefixes="ametys resolver math">
                
    <xsl:import href="service:web://pages/services/common.xsl"/>
    
    <xsl:variable name="header" select="string(ametys:serviceParameter('header')/text())"/>
    <xsl:variable name="link" select="ametys:serviceParameter('link')/text()"/>
    <xsl:variable name="link-text" select="ametys:serviceParameter('link-text')/text()"/>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">tasklist</xsl:variable>
    <xsl:variable name="common-service-name">service-tasklist</xsl:variable>
    
    <xsl:variable name="nbMaxUser" select="3"/>
    
    <xsl:template name="common-service-head-css">
        <xsl:variable name="url"><xsl:value-of select="ametys:absoluteUriPrefix()" />/plugins/workspaces/<xsl:value-of select="ametys:site()" />/project-tags.min.css</xsl:variable>
        <link rel="stylesheet" href="{$url}" />
    </xsl:template>
    
    <!-- +
         | HEAD
         + -->   
    <!-- Used by common -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- +
         | BODY
         + -->
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-content">
    	<xsl:choose>
    		<xsl:when test="task">
    			<xsl:call-template name="tasks"/>
    		</xsl:when>
    		<xsl:otherwise>
    			<xsl:call-template name="tasks-empty"/>
    		</xsl:otherwise>
    	</xsl:choose>
    	
    	<xsl:call-template name="link" />
    </xsl:template>
    
    <xsl:template name="tasks-empty">
        <p><i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_SIMPLE_TASK_NO_UNFINISHED_RESULTS" /></p>
    </xsl:template>
    
    <xsl:template name="tasks">
    	<ul class="tasks">
    		<xsl:apply-templates select="task"/>
    	</ul>
    </xsl:template>
    
    <xsl:template match="task">
        <li>
        	<xsl:attribute name="class"><xsl:call-template name="common-utils-class"/> task-entry</xsl:attribute>
            <xsl:call-template name="task-project"/>
            <xsl:call-template name="task-title"/>
            <xsl:call-template name="task-assignments" />
        </li>
    </xsl:template>
    
    <xsl:template name="task-project">
    	<div class="task-project-title"><xsl:value-of select="project" /></div>
    </xsl:template>
    
    <xsl:template name="task-title">
    	<div class="task-title">
             <xsl:choose>
                 <xsl:when test="@pageId">
                     <a href="{resolver:resolve('page', @pageId)}"><xsl:value-of select="label" /></a>
                 </xsl:when>
                 <xsl:otherwise>
                     <xsl:value-of select="label" />
                 </xsl:otherwise>
             </xsl:choose>
         </div>
    </xsl:template>
    
    <xsl:template name="task-assignments">
        <div class="task-assignments">
            <xsl:for-each select="assignments">
                <!-- limit to 3 assignments -->
                <xsl:if test="position() &lt;= $nbMaxUser">
                    <xsl:call-template name="task-assignments-user"/>
                </xsl:if>
            </xsl:for-each>
            
            <!-- display some dots if there are more than 3 assignments -->
            <xsl:if test="assignments/user[$nbMaxUser]">
                <div class="task-assignment-more">...</div>
            </xsl:if>
        </div>
    </xsl:template>
    
    <xsl:template name="task-assignments-user">
   		<div class="task-assignment">
            <img class="task-user-img" src="{$site-uri-prefix}/_plugins/user-directory/user/{@populationId}/{uriutils:encodePath(@login)}/image_24" />
            <span class="task-user-name"><xsl:value-of select="." /></span>
        </div>
    </xsl:template>
    
    <!-- Template to use the link -->
    <xsl:template name="link">
        <xsl:if test="starts-with($link, 'page://')">
            <xsl:variable name="url" select="resolver:resolve('page', $link)"/>
            <xsl:if test="$url != ''">
                <div class="link tasklist-link">
                    <a href="{$url}">
                        <xsl:choose>
                            <xsl:when test="$link-text != ''">
                                <xsl:value-of select="$link-text"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="ametys:pageTitle($link)"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </a>
                </div>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>
