/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the representation of a project.
 */
Ext.define(
	"Ametys.plugins.workspaces.project.Project", 
	{
		config: {
			/**
			 * @cfg {String} id The unique id of the project
			 */
			/**
			 * @method getId Get the #cfg-id
			 * @return {String} The id
			 */
			/** @ignore */
			id: null,
			/**
			 * @cfg {String} name The name of the project
			 */
			/**
			 * @method getName Get the #cfg-name
			 * @return {String} The name
			 */
			/** @ignore */
			name: null,
			/**
			 * @cfg {String} parentId The unique id of the parent's project. Can be null if the project is a root project
			 */
			/**
			 * @method getParentId Get the #cfg-parentId
			 * @return {String} The parent's id
			 */
			/** @ignore */
			parentId: null,
			/**
			 * @cfg {String} title The title of the project
			 */
			/**
			 * @method getTitle Get the #cfg-title
			 * @return {String} The title
			 */
			/** @ignore */
			title: null,
			/**
			 * @cfg {String} description The description of the project
			 */
			/**
			 * @method getDescription Get the #cfg-description
			 * @return {String} The description
			 */
			/** @ignore */
			description: null,
			/**
			 * @cfg {String} path The JCR path of the project
			 */
			/**
			 * @method getPath Get the #cfg-path
			 * @return {String} The JCR path
			 */
			/** @ignore */
			path: null,
			/**
			 * @cfg {String} creationDate The creation date as String
			 */
			/**
			 * @method getCreationDate Get the #cfg-creationDate
			 * @return {String} The creation date
			 */
			/** @ignore */
			creationDate: null,
			/**
			 * @cfg {String} mailingList The mailing list
			 */
			/**
			 * @method getMailingList Get the #cfg-mailingList
			 * @return {String} The mailing list
			 */
			/** @ignore */
			mailingList: null,
            /**
             * @cfg {String} inscriptionStatus The inscription status
             */
            /**
             * @method getInscriptionStatus Get the #cfg-inscriptionStatus
             * @return {String} The inscription status
             */
            /** @ignore */
            inscriptionStatus: null,
            /**
             * @cfg {String} defaultProfile The default profile for new members
             */
            /**
             * @method getDefaultProfile Get the #cfg-defaultProfile
             * @return {String} The default profile for new members
             */
            /** @ignore */
            defaultProfile: null,
			/**
			 * @cfg {Boolean} valid True if the project is valid
			 */
			/**
			 * @method getValid Get the #cfg-valid
			 * @return {Boolean} The valid state
			 */
			/** @ignore */
			valid: false,
			/**
			 * @cfg {String[]} sites List of the sites associated with the project
			 */
			/**
			 * @method getSite Get the #cfg-site
			 * @return {Object} The site of project
			 */
			/** @ignore */
			site: null
		},
		
		
		/**
		 * Creates a page instance
		 * @param {Object} config See configuration doc.
		 */
		constructor: function (config)
		{
			this.initConfig(config);
			
			this._messageTarget = config.messageTarget || Ametys.message.MessageTarget.PROJECT;
		},
		
		/**
		 * Get the project's properties
		 * @return {Object} The page's properties
		 */
		getProperties: function (initialProperty)
		{
			return Ext.apply ({
					id: this._id,
					name: this._name,
					parentId: this._parentId,
					path: this._path,
					siteName: this._site ? this._site.name : null,
					valid : this._valid
				}, initialProperty
			);
		}
	}
);

