/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Abstract widget to select project tags.<br>
 * See {@link Ametys.plugins.workspaces.project.helper.ChooseTag}<br>
 * 
 * This widget is registered for fields of type Ametys.form.WidgetManager#TYPE_STRING.
 */
Ext.define('Ametys.plugins.workspaces.project.widget.AbstractProjectTag', {
    extend : 'Ametys.cms.form.widget.Tag',
    
    plugin: 'workspaces',
    url: 'tags.json',
    
    /**
     * @cfg {String} [tagModel="Ametys.plugins.workspaces.project.tag.ProjectTagNode"] The id of model for tag nodes
     */ 
    tagModel: "Ametys.plugins.workspaces.project.tag.ProjectTagNode",
    
    /**
     * @cfg {String} [tagsDAO="org.ametys.plugins.workspaces.tags.ProjectTagsDAO"] The DAO component to use for tags
     */ 
    tagsDAO: "org.ametys.plugins.workspaces.tags.ProjectTagsDAO",
    
    /**
     * @cfg {String} dialogTitle The title of the dialog box to choose tag
     */ 
    /**
     * @cfg {String} dialogHelpMsg The help message to display on top of dialog box to choose tag
     */ 
    
    constructor: function (config)
    {
        config.url = config.url || 'tags.json';
        config.plugin = config.plugin || 'workspaces';
        
        this.callParent(arguments);
    },
    
    _showTagPopup : function() 
    {
        Ametys.plugins.workspaces.project.helper.ChooseTag.open(this._getTagPopUpConfiguration());
    },
    
    _getTagsTitle: function(values, callback, scope)
    {
        Ametys.data.ServerComm.callMethod({
            role: this.tagsDAO, 
            methodName: 'getTagsTitle', 
            parameters: [values, this.getContextualParameters() ],
            errorMessage: "{{i18n plugin.cms:PLUGINS_CMS_HANDLE_TAGS_TAG_ERROR}}",
            callback: {
                handler: callback,
                scope: scope || this
            }
        });
    },
    
    _getTagPopUpConfiguration: function()
    {
        return Ext.apply(this.callParent(arguments), {
            plugin: this.plugin,
            url: this.url,
            tagModel: this.tagModel,
            tagsDAO: this.tagsDAO,
            title: this.dialogTitle || "{{i18n plugin.cms:PLUGINS_CMS_HELPER_CHOOSETAG_TITLE}}",
            helpMessage: this.dialogHelpMsg
        });
    }
    
})