<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">
                              
    <xsl:import href="view://stylesheets/mail/abstract2notification.xsl"/>
    
    <xsl:template name="title">
        <!-- It's not possible to set the attribute of an html element of the i18n key with a i18n param
            It will be done by the XSL after. Provide the data in an attribute of the title element here.
            In the i18n key, set the name of this attribute in an attribute data-href of the a element.
            The rest will be done by the skin -->
        <title root-data="true" projectURL="{project/url}">
            <i18n:translate>
                <i18n:text i18n:key="PROJECT_MAIL_NOTIFICATION_EVENT_BODY_{/notification/eventKey}_TITLE" i18n:catalogue="plugin.workspaces"/>
                <i18n:param name="issuerFullname"><xsl:value-of select="issuer/user/fullname"/></i18n:param>
                <i18n:param name="projectTitle"><xsl:value-of select="project/title"/></i18n:param>
                <i18n:param name="projectUrl"><xsl:value-of select="project/url"/></i18n:param>
            </i18n:translate>
        </title>
    </xsl:template>
    
     <xsl:template name="section-hint">
        <!-- It's not possible to set the attribute of an html element of the i18n key with a i18n param
            It will be done by the XSL after. Provide the data in an attribute of the title element here.
            In the i18n key, set the name of this attribute in an attribute data-href of the a element.
            The rest will be done by the skin -->
        <hint root-data="true" projectURL="{project/url}">
            <i18n:translate>
                <i18n:text i18n:key="PROJECT_MAIL_NOTIFICATION_EVENT_BODY_{/notification/eventKey}_SECTION_HINT" i18n:catalogue="plugin.workspaces"/>
                <i18n:param name="issuerFullname"><xsl:value-of select="issuer/user/fullname"/></i18n:param>
                <i18n:param name="projectTitle"><xsl:value-of select="project/title"/></i18n:param>
                <i18n:param name="projectUrl"><xsl:value-of select="project/url"/></i18n:param>
            </i18n:translate>
        </hint>
    </xsl:template>
    
    <xsl:template name="section-items">
        <items highlight="true">
            <xsl:apply-templates select="project"/>
        </items>
    </xsl:template>
    
    <xsl:template match="project">
        <item type="project">
            <xsl:copy-of select="title"/>
            <xsl:copy-of select="description"/>
        </item>
    </xsl:template>
    
</xsl:stylesheet>