<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:uri="org.ametys.core.util.URIUtils"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent">
    
    <xsl:import href="view://stylesheets/mail/abstract2notification.xsl"/>
    <xsl:import href="view://stylesheets/utils.xsl"/>
    
    <xsl:template match="activity">
        <item type="content">
            <xsl:apply-templates select="." mode="title"/>
            <xsl:apply-templates select="." mode="author"/>
            <xsl:apply-templates select="." mode="date"/>
            <xsl:apply-templates select="." mode="content"/>
            <xsl:apply-templates select="." mode="tags"/>
            <xsl:apply-templates select="." mode="image"/>
        </item>
    </xsl:template>

    <xsl:template match="activity" mode="title">
        <title><xsl:value-of select="contentTitle"/></title>
    </xsl:template>
    
    <xsl:template match="activity" mode="content">
        <content><xsl:value-of select="contentSummary"/></content>
    </xsl:template>
    
    <xsl:template match="activity" mode="tags">
        <xsl:if test="contentTags/*">
            <tags>
                <xsl:for-each select="contentTags/*">
                    <tag><xsl:value-of select="."/></tag>
                </xsl:for-each>
            </tags>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="activity" mode="image">
        <xsl:if test="ametys:hasValue(contentId, 'illustration/image')">
            <xsl:variable name="img" select="ametys:contentAttribute(contentId, 'illustration/image')"/>
            <images>
                <image>
                    <src><xsl:value-of select="resolver:resolveBoundedImageAsBase64($img/@type, $img/@uri, 340, 490)"/></src>
                </image>
            </images>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="section-button">
        <button>
            <text>
                <i18n:text i18n:key="PROJECT_MAIL_NOTIFICATION_BODY_PROJECT_NEWS_BUTTON_TEXT" i18n:catalogue="plugin.workspaces"/>
            </text>
            <href>
                <xsl:choose>
                    <xsl:when test="activity/pageId != ''">
                        <xsl:value-of select="resolver:resolve('page', activity/pageId, false(), true())"/>
                    </xsl:when>
                    <xsl:otherwise><xsl:value-of select="project/url"/></xsl:otherwise>
                </xsl:choose>
            </href>
            <width>300</width>
        </button>
    </xsl:template>
</xsl:stylesheet>