<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:exslt="http://exslt.org/common"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:avatar="org.ametys.plugins.core.ui.user.ProfileImageResolverHelper">
                              
    <!-- 
    <item type="member">
        <eventType>MEMBER_DELETED|MEMBER_ADDED</eventType>
        <memberType>user|group</memberType>
        <date>yyyy-MM-dd'T'HH:mm:ss.SSSXXX</date>
        <title/>
        <identity/>
        <author>
            <login/>
            <populationId/>
            <fullname/>
            <firstname/>
            <email/>
            ...
        </author>
    <item>
     -->
     
    <xsl:template match="item[@type='member']" mode="item-content">
        <table align="left" border="0" cellpadding="0" cellspacing="0" role="presentation" style="border-collapse: collapse; border-spacing: 0px; width: 100%;">
            <tbody>
                <tr>
                    <td width="42" style="padding: 0px; direction: ltr; font-size: 0px; word-break: break-word;" valign="top">
                        <xsl:apply-templates select="." mode="item-icon"/>
                    </td>
                    <xsl:call-template name="row-horizontal-spacer">
                        <xsl:with-param name="width">5</xsl:with-param>
                    </xsl:call-template>
                    <td style="direction: ltr; font-size: 0px; padding: 0px; word-break: break-word;">
                        <xsl:call-template name="table-vertical-spacer">
                            <xsl:with-param name="height">0</xsl:with-param>
                        </xsl:call-template>
                        <xsl:apply-templates select="." mode="item-title"/>
                        <xsl:apply-templates select="." mode="item-details">
                            <xsl:with-param name="date" select="date"></xsl:with-param>
                        </xsl:apply-templates>
                    </td>
                </tr>
            </tbody>
        </table>
    </xsl:template>
    
    <xsl:template match="item[@type='member']" mode="item-icon">
        <div style="width: 42px; height: 42px; display: inline-block;">
            <xsl:variable name="imgSrc">
                <xsl:choose>
                    <xsl:when test="memberType = 'user'">
                        <xsl:variable name="lang"><xsl:value-of select="ametys:lang()"/></xsl:variable>
                        <xsl:value-of select="avatar:resolveAsBase64(substring-before(identity, '#'), substring-after(identity, '#'), 40, $lang)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="ametys:pluginImageBase64('workspaces', 'img/mail/icon-group.png')"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            <img width="40" height="40" src="{$imgSrc}" alt="" style="display: block; border: solid 1px #fff; border-radius: 50%; outline: none; text-decoration: none;"></img>
        </div>
    </xsl:template>
    
</xsl:stylesheet>