/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
import { defineStore } from 'pinia'
import { callMethod } from '@common/helper/ServerCommHelper.js';
import { transformToMember } from '@common/helper/MemberHelper.js';

/**
 * Pinia store for getting a list of current project members
 */
export const useProjectMembersStore = defineStore('projectMembers', {
  state: () => (
    {
        members: [] // list of project members
    }),
    actions:
    {
        /**
         * Load the project members
         */
        async getProjectMembers()
        {
            if (this.members.length === 0)
            {
              await callMethod({
                role: 'org.ametys.plugins.workspaces.tasks.WorkspaceTaskDAO',
                methodName: 'getProjectMembers',
                parameters: []
              })
                .then(data => {
                    this.members = data.members.map(transformToMember);
                })
            }
        },

    },
})
