/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import { createApp } from 'vue'
import { createVuetify } from 'vuetify'
import { createPinia } from 'pinia'



import { fa } from 'vuetify/iconsets/fa'
import { md } from 'vuetify/iconsets/md'

// Vue base component
import App from '@/CalendarModule.vue';

// Translations provided by Vuetify
import { fr, en } from 'vuetify/locale'

window['vue-calendar-run'] = function (selector, config) {

    const vuetify = createVuetify({
        icons: {
            defaultSet: 'fa',
            sets: {
              fa,
              md
            },
        },
        locale: {
            messages: {
                fr: fr,
                en: en
            },
        },
    })
    
    const app = createApp(App);
    app.use(vuetify);

    app.config.globalProperties.$restrictedColorsMap = config.colorsMap().colors;
    app.config.globalProperties.$colorsMap = {...config.colorsMap().resourceColor, ...config.colorsMap().colors};
    app.config.globalProperties.$resourceCalendar = config.resourceCalendar();
    app.config.globalProperties.$recurrenceTypes = config.recurrenceTypes();
    app.config.globalProperties.$glyphs = config.glyphs();
    const pinia = createPinia()
    pinia.use(({ store }) => {
      store.$restrictedColorsMap = app.config.globalProperties.$restrictedColorsMap;
      store.$colorsMap = app.config.globalProperties.$colorsMap;
      store.$resourceCalendar = app.config.globalProperties.$resourceCalendar;
      store.$recurrenceTypes = app.config.globalProperties.$recurrenceTypes;
      store.$glyphs = app.config.globalProperties.$glyphs;
    });
    app.use(pinia);
    app.mount(selector);
};

