/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import { mapActions, mapState } from 'pinia';
import { useThreadStore } from '@/stores/thread'
import { useTagsStore } from '@common/store/project-tags/tags'
import { useColorsStore } from '@common/store/project-tags/colors'

import $ from 'jQuery';
import AmetysFront from 'AmetysFront';
export default {
  data() {
    return {
      boilerplateLoading: true,
      paginationLoading: false,
    };
  },
  computed: {
    ...mapState(useThreadStore, ['categoryThreadsCount', 'usedTags', 'threadsPagination', 'threads']),
    ...mapState(useTagsStore, ['tags']),
  },
  methods: {
    ...mapActions(useThreadStore, ['getThreadsByPage', 'getThreadIds', 'getThreadsByPage', 'getCategoryThreadCount']),
    ...mapActions(useThreadStore, {getUsedTags: 'loadUsedTags'}),
    ...mapActions(useColorsStore, ['loadColors']),

    async handleCategorySelected(category) {
      const query = this.getQuery();
      if ((this.threadView || this.threadCreate) && query.q) {
        delete query.q;
      }
      if (query.category && query.category == category.id) return;
      query.category = category.id;

      await this.setRouteQuery(query);
      this.handleThreads();
    },
    async handlePaginate(currentPage) {
      this.paginationLoading = true;
      const query = this.getQuery();
      if (query.page) delete query.page;
      query.page = currentPage + 1;
      await this.getThreadsByPage(query.page);
      this.paginationLoading = false;
    },
    async handleAllCategroySelected(check = true) {
      const query = this.getQuery();
      if ((this.threadView || this.threadCreate) && query.q) {
        delete query.q;
      }
      if (check) {
        if (!query.category) return;
        delete query.category;
      }
      await this.setRouteQuery(query);
      this.handleThreads();
    },
    async handleTagSelected(tag) {
      /* [TEMP] */
      this.threadModal = false;
      const query = this.getQuery();

      if ((this.threadView || this.threadCreate) && query.q) {
        delete query.q;
      }

      if (query.tag && query.tag == tag.name) {
        delete query.tag;
      } else {
        query.tag = tag.name;
      }

      await this.setRouteQuery(query);
      this.handleThreads();
      if (query.tag) this.scrollToActiveTab();
    },
    async handleStatusSelected(item) {
      let type = item.type;
      const query = this.getQuery();

      if (query[type] == item.value.toString()) return;
      query[type] = item.value;

      await this.setRouteQuery(query);
      this.handleThreads();
    },
    async handleStatusUnselected(item) {
      const query = this.getQuery();
      delete query[item.type];
      await this.setRouteQuery(query);
      this.handleThreads();
    },
    async handleSearch(q) {
      q = AmetysFront.Utils.deemphasize(q.toLowerCase());
      const query = this.getQuery();
      if (query.q && !q) delete query.q;
      else query.q = q;
      await this.setRouteQuery(query);
      await this.handleThreads();
    },
    async handleToggleView(val) {
      const query = this.getQuery();
      query.view = val;
      await this.setRouteQuery(query);
    },
    async handleThreads(params = {}) {
      this.boilerplateLoading = true;
      let q = '';
      const query = this.getQuery();
      if (query.page) delete query.page;

      if (query.q) {
        try {
          q = decodeURIComponent(query.q);
        } catch (e) {
          query.q = '';
          console.error(e);
        }
      }

      for (const key in params) {
        query[key] = params[key];
      }

      await this.setRouteQuery(query);

      if (query.q) query.q = q;
      await this.getThreadIds(query);
      await this.getThreadsByPage(1);
      this.boilerplateLoading = false;
    },
    scrollToActiveTab() {
      this.$nextTick(function () {
        const scrollbar = $('#tags-list');
        const element = $('#tags-list .activeChips');
        if (element.length > 0) {
          const isNotInVeiw = element.offset().top - scrollbar.offset().top + 20 > scrollbar.height();
          if (isNotInVeiw) {
            const top = $('#tags-list .activeChips').position().top + scrollbar.scrollTop() - scrollbar.position().top;
            scrollbar.animate({ scrollTop: top + 50 }, 1000);
          }
        }
      });
    },
  },
};
