/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.alert;

import java.util.Collections;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;

import org.ametys.plugins.workspaces.AbstractWorkspaceModule;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.Page.PageType;
import org.ametys.web.repository.sitemap.Sitemap;

/**
 * Workspaces module for alerts
 */
public class AlertWorkspaceModule extends AbstractWorkspaceModule
{
    /** The id of alert module */
    public static final String ALERT_MODULE_ID = AlertWorkspaceModule.class.getName();
    
    /** Workspaces alerts node name */
    private static final String __WORKSPACES_ALERTS_NODE_NAME = "alerts";
    
    public String getId()
    {
        return ALERT_MODULE_ID;
    }

    public int getOrder()
    {
        return ORDER_ALERTS;
    }

    public String getModuleName()
    {
        return __WORKSPACES_ALERTS_NODE_NAME;
    }

    public Set<String> getAllowedEventTypes()
    {
        return Collections.EMPTY_SET;
    }

    @Override
    protected String getModulePageName()
    {
        return "alerts";
    }

    public I18nizableText getModuleTitle()
    {
        return new I18nizableText("plugin." + _pluginName, "PLUGINS_WORKSPACES_PROJECT_MODULE_ALERTS_LABEL");
    }
    public I18nizableText getModuleDescription()
    {
        return new I18nizableText("plugin." + _pluginName, "PLUGINS_WORKSPACES_PROJECT_MODULE_ALERTS_DESCRIPTION");
    }

    @Override
    protected I18nizableText getModulePageTitle()
    {
        return new I18nizableText("plugin." + _pluginName, "PLUGINS_WORKSPACES_PROJECT_WORKSPACE_PAGE_ALERTS_TITLE");
    }
    
    @Override
    protected ModifiablePage _createModulePage(Project project, Sitemap sitemap, String name, I18nizableText pageTitle, String skinTemplate)
    {
        if (!sitemap.hasChild(name))
        {
            ModifiablePage page = sitemap.createChild(name, "ametys:defaultPage");
            
            // Title should not be missing, but just in case if the i18n message or the whole catalog does not exists in the requested language
            // to prevent a non-user-friendly error and still generate the project workspace.
            page.setTitle(StringUtils.defaultIfEmpty(_i18nUtils.translate(pageTitle, sitemap.getName()), "Missing title"));
            page.setType(PageType.NODE);
            page.setSiteName(sitemap.getSiteName());
            page.setSitemapName(sitemap.getName());
            
            sitemap.saveChanges();
            
            return page;
        }
        else
        {
            return null;
        }
    }

    @Override
    protected void initializeModulePage(ModifiablePage modulePage)
    {
        modulePage.untag("SECTION");
    }
    
    @Override
    protected String getModulePageTemplate() 
    {
        return "page";
    }

    @Override
    protected boolean _showActivatedStatus()
    {
        return false;
    }
}
