/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.calendars;

/**
 * Constants for calendar observers.
 */
public interface ObservationConstants
{
    // ----------------------------//
    // Calendar and calendar events//
    // ----------------------------//
    
    /** Event id when a calendar is created. */
    public static final String EVENT_CALENDAR_CREATED = "calendar.created";
    
    /** Event id when a calendar is updated. */
    public static final String EVENT_CALENDAR_UPDATED = "calendar.updated";
    
    /** Event id when a calendar is deleted. */
    public static final String EVENT_CALENDAR_DELETED = "calendar.deleted";
    
    /** Event id when a calendar is moved. */
    public static final String EVENT_CALENDAR_MOVED = "calendar.moved";
    
    /** Event id when a calendar event is created. */
    public static final String EVENT_CALENDAR_EVENT_CREATED = "calendar.event.created";
    
    /** Event id when a calendar event is updated. */
    public static final String EVENT_CALENDAR_EVENT_UPDATED = "calendar.event.updated";
    
    /** Event id just before a calendar event is deleted. */
    public static final String EVENT_CALENDAR_EVENT_DELETING = "calendar.event.deleting";
    
    /** Event id when a calendar event is deleted. */
    public static final String EVENT_CALENDAR_EVENT_DELETED = "calendar.event.deleted";
    
    /** Event id when a calendar resource is created. */
    public static final String EVENT_CALENDAR_RESOURCE_CREATED = "calendar.resource.created";
    
    /** Event id when a calendar resource is updated. */
    public static final String EVENT_CALENDAR_RESOURCE_UPDATED = "calendar.resource.updated";
    
    /** Event id when a calendar resource is deleted. */
    public static final String EVENT_CALENDAR_RESOURCE_DELETED = "calendar.resource.deleted";
    
    
    // ----------------//
    // Event arguments //
    // ----------------//
    
    /** Argument name for processed calendar */
    public static final String ARGS_CALENDAR = "calendar";
    
    /** Argument name for processed calendar's event */
    public static final String ARGS_CALENDAR_EVENT = "calendar.event";
}

