/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.calendars.resources;

import org.ametys.cms.data.ametysobject.ModifiableModelAwareDataAwareAmetysObject;
import org.ametys.plugins.repository.RemovableAmetysObject;

/**
 * Modifiable Calendar Interface
 */
public interface CalendarResource extends RemovableAmetysObject, ModifiableModelAwareDataAwareAmetysObject
{
    /**
     * Get the id of the resource
     * @return the id of the resource
     */
    public String getCalendarResourceId();
    
    /**
     * set the id of the resource
     * @param id The id of the resource
     */
    public void setCalendarResourceId(String id);

    /**
     * Get the title of the resource
     * @return the title of the resource
     */
    public String getTitle();
    
    /**
     * set the title of the resource
     * @param title The title
     */
    public void setTitle(String title);

    /**
     * Get the special instructions of the resource
     * @return the special instructions of the resource
     */
    public String getInstructions();
    
    /**
     * set the special instructions of the resource
     * @param instructions The special instructions
     */
    public void setInstructions(String instructions);

    /**
     * Get the icon of the resource
     * @return the icon of the resource
     */
    public String getIcon();
    
    /**
     * set the icon of the resource
     * @param icon The icon to set
     */
    public void setIcon(String icon);
        
}
