/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.categories;

import org.ametys.cms.tag.AbstractTagProviderExtensionPoint;
import org.ametys.plugins.repository.RepositoryConstants;

/**
 * This class is in charge to load and initialize category tag providers.
 */
public class CategoryProviderExtensionPoint extends AbstractTagProviderExtensionPoint<Category>
{
    /** Avalon Role */
    public static final String ROLE = CategoryProviderExtensionPoint.class.getName();
    
    /** JCR nodetype for tags */
    public static final String TAGS_NODETYPE = RepositoryConstants.NAMESPACE_PREFIX + ":project-categories";
    
    /** JCR node name for tags */
    public static final String TAGS_NODENAME = "project-categories";
    
    
    @Override
    public String getTagsNodeName()
    {
        return TAGS_NODENAME;
    }
    
    @Override
    public String getTagsNodeType()
    {
        return TAGS_NODETYPE;
    }
}
