/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.dav;

import java.io.IOException;

import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.reading.AbstractReader;
import org.xml.sax.SAXException;

/**
 * Reader for WebDAV OPTIONS method
 */
public class WebdavOptionsReader extends AbstractReader
{
    public void generate() throws IOException, SAXException, ProcessingException
    {
        Response response = ObjectModelHelper.getResponse(objectModel);

        response.setHeader("Allow", "COPY, DELETE, GET, HEAD, LOCK, OPTIONS, POST, PROPFIND, PROPPATCH, PUT, UNLOCK, MKCOL");
        response.setHeader("DAV", "1, 2");
        response.setHeader("Ms-Author-Via", "DAV");
    }
}
