/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.members;

import javax.jcr.Node;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.RepositoryConstants;
import org.ametys.plugins.repository.jcr.DefaultAmetysObjectFactory;
import org.ametys.plugins.workspaces.data.type.ModelItemTypeExtensionPoint;

/**
 * {@link AmetysObjectFactory} for handling {@link JCRProjectMember}s.
 */
public class JCRProjectMemberFactory extends DefaultAmetysObjectFactory
{
    /** Node type for project member */
    public static final String MEMBER_NODETYPE = RepositoryConstants.NAMESPACE_PREFIX + ":project-member";
    
    private ModelItemTypeExtensionPoint _projectDataTypeExtensionPoint;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _projectDataTypeExtensionPoint = (ModelItemTypeExtensionPoint) smanager.lookup(ModelItemTypeExtensionPoint.ROLE_PROJECT);
    }
    
    @Override
    public JCRProjectMember getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException
    {
        return new JCRProjectMember(node, parentPath, this);
    }
    
    ModelItemTypeExtensionPoint getProjectDataTypeExtensionPoint()
    {
        return _projectDataTypeExtensionPoint;
    }
}
