/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.members.observers;

import java.util.List;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.content.indexing.solr.SolrIndexer;
import org.ametys.cms.indexing.IndexingObserver;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;

/**
 * {@link Observer} for reindexing member' content when a member was added or removed from a project
 *
 */
public class IndexMemberObserver extends AbstractMemberObserver implements IndexingObserver
{
    private SolrIndexer _solrIndexer;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _solrIndexer = (SolrIndexer) smanager.lookup(SolrIndexer.ROLE);
    }

    @Override
    protected void _internalObserve(Event event, List<Content> userContents) throws Exception
    {
        if (!userContents.isEmpty())
        {
            try
            {
                _solrIndexer.indexContents(userContents);
            }
            catch (Exception e)
            {
                getLogger().error("Error while trying to re-index the members", e);
            }
        }
    }
}
