/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.project.enumerators;

import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.cms.languages.Language;
import org.ametys.cms.languages.LanguagesManager;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;

/**
 * Enumerator for the languages available to a project
 */
public class ProjectLanguagesEnumerator extends AbstractLogEnabled implements Enumerator<String>, Serviceable
{
    private LanguagesManager _languagesManager;

    public void service(ServiceManager manager) throws ServiceException
    {
        _languagesManager = (LanguagesManager) manager.lookup(LanguagesManager.ROLE);
    }
    
    public I18nizableText getEntry(String code) throws Exception
    {
        Language language = _languagesManager.getLanguage(code);
        return language != null ? language.getLabel() : null;
    }

    public Map<String, I18nizableText> getEntries() throws Exception
    {
        Map<String, I18nizableText> result = new HashMap<>();
        
        Map<String, Language> availableLanguages = _languagesManager.getAvailableLanguages();
        for (Language availableLanguage : availableLanguages.values())
        {
            result.put(availableLanguage.getCode(), availableLanguage.getLabel());
        }
        
        return result;
    }
}
