/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.project.notification.schedule;

import java.time.LocalTime;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

import org.ametys.plugins.core.impl.schedule.StaticRunnable;
import org.ametys.runtime.config.Config;

/**
 * Runnable for notification summary
 *
 */
public class SendNotificationSummaryRunnable extends StaticRunnable
{
    @Override
    public void configure(Configuration configuration) throws ConfigurationException
    {
        DefaultConfiguration modifiedConfiguration = new DefaultConfiguration(configuration);
        
        String frequency = configuration.getChild("frequency").getValue("daily");
        
        // Set our custom cron
        String hourParamName = configuration.getChild("param-hour").getValue("").trim();
        String hourCfg = Config.getInstance().getValue(hourParamName);
        if (hourCfg != null)
        {
            LocalTime lt = LocalTime.parse(hourCfg);
            
            String cronExpression = "0 " /*seconds*/ + lt.getMinute() /*minutes*/ + " " + lt.getHour() /*hour*/;
            
            if ("daily".equals(frequency))
            {
                cronExpression += " * * ? *" /* every day, on every month, without restriction on day-of-week, on every year*/;
            }
            else if ("weekly".equals(frequency))
            {
                cronExpression += " ? * MON *"; /* every monday */
            }
            else if ("monthly".equals(frequency))
            {
                cronExpression += " 1 * ? *" /* 1st day of every month */;
            }
            
            DefaultConfiguration cronConfig = new DefaultConfiguration("cron");
            cronConfig.setValue(cronExpression);
            modifiedConfiguration.addChild(cronConfig);
        }
        else
        {
            // FireProcess = never
            DefaultConfiguration fireProcessConfig = new DefaultConfiguration("fire-process");
            fireProcessConfig.setValue("never");
            modifiedConfiguration.addChild(fireProcessConfig);
        }
        
        // Call configure of StaticRunnable
        super.configure(modifiedConfiguration);
    }
    
}
