/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.tags;

import java.util.Map;
import java.util.stream.Collectors;

import org.ametys.cms.tag.CMSTag;
import org.ametys.cms.tag.DefaultTag;
import org.ametys.cms.tag.TagTargetType;

/**
 * This class represent a project tag (used in modules) as a CMS Tag
 */
public class ProjectCMSTag extends CMSTag
{
    /** The prefix for all tags issue from module tags */
    public static final String TAG_PREFIX = "WORKSPACES_TAG_";
    
    private DefaultTag _tag;
    
    /**
     * Constructor
     * @param projectTag the project tag
     * @param parent the parent CMS tag
     * @param targetType the target type
     */
    public ProjectCMSTag(DefaultTag projectTag, CMSTag parent, TagTargetType targetType)
    {
        super(TAG_PREFIX + projectTag.getName(), TAG_PREFIX + projectTag.getName(), parent, projectTag.getTitle(), projectTag.getDescription(), TagVisibility.PUBLIC, targetType, 0);
        _tag = projectTag;
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public CMSTag getTag(String tagId)
    {
        DefaultTag projectTag = _tag.getTag(tagId);
        return new ProjectCMSTag(projectTag, this, this.getTarget());
    }
    
    
    @Override
    public Map<String, CMSTag> getTags()
    {
        return _tag.getTags().values()
            .stream()
            .map(projectTag -> new ProjectCMSTag(projectTag, this, this.getTarget()))
            .collect(Collectors.toMap(tag -> tag.getId(), tag -> tag));
    }
}
