<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:xalan="http://xml.apache.org/xalan"
                xmlns:math="java.lang.Math"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="math ametys resolver">
        
    <xsl:template name="input-file-js">
        <script type="text/javascript">
            function changeFile($event, id) {
            
                var input = $event;
                var url = $j($event).val()
                var ext = url.substring(url.lastIndexOf('.') + 1).toLowerCase();
                var parts = url.split("\\");
                var fileName = parts[parts.length - 1];
                $j('.download-' + id).find('label span').html(fileName);

                if(fileName == '') {
                    $j($event).val('');
                    $j('.download-' + id).find('label span').html("<i18n:text i18n:key="SKIN_FORMS_SELECT_FILE" i18n:catalogue="skin.{$skin}"/>");
                    $j('.download-' + id).find('.close').fadeOut();
                } else {
                    $j('.download-' + id).find('.close').fadeIn();
                }
            }

            function removeFile(e) {
                const parent = $j(e).parent();
                $j(parent).find('input').val('');
                $j(parent).find('label span').html("<i18n:text i18n:key="SKIN_FORMS_SELECT_FILE" i18n:catalogue="skin.{$skin}"/>");
                $j(parent).find('.close').fadeOut();
            }
        </script>
    </xsl:template>
    
    <xsl:template name="input-image-file-js">
        <script type="text/javascript">
            function changePhoto($event, id) {
                var input = $event;
                var url = $j($event).val()
                var ext = url.substring(url.lastIndexOf('.') + 1).toLowerCase();
                if (input.files &amp;&amp; input.files[0] &amp;&amp; (ext == "gif" || ext == "png" || ext == "jpeg" || ext == "jpg")) {
                    var reader = new FileReader();
        
                    reader.onload = function (e) {
                        $j('.preview-' + id).find('img').attr('src', e.target.result);
                        $j('.preview-' + id).next('.add-photo').hide();
                        $j('.preview-' + id).show();
                        $j('#photo-' + id).val(e.target.result);
                    }
                    reader.readAsDataURL(input.files[0]);
                }
            }
        
            function closePreview(e) {
                var preview = $j(e).parent();
        
                $j(preview).hide();
                $j(preview).next('.add-photo').show();
                $j(preview).next('.add-photo').find('input').val('');
            }
        </script>        
    </xsl:template>
    
    <xsl:template name="download-icon">
        <svg version="1.1" id="Calque_1" xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512"
                    style="enable-background:new 0 0 512 512;" xml:space="preserve">
                    <g id="Solid">
                        <path
                            d="M239,385c9.4,9.4,24.6,9.4,33.9,0c0,0,0,0,0,0l90.5-90.5c9.4-9.4,9.4-24.6,0-33.9c-9.4-9.4-24.6-9.4-33.9,0L280,310.1V48
c0-13.3-10.7-24-24-24c-13.3,0-24,10.7-24,24v262.1l-49.5-49.5c-9.4-9.4-24.6-9.4-33.9,0c-9.4,9.4-9.4,24.6,0,33.9L239,385z"
                                                fill="#FC7D85" />
                        <path d="M464,232c-13.3,0-24,10.7-24,24v184H72V256c0-13.3-10.7-24-24-24s-24,10.7-24,24v192c0,22.1,17.9,40,40,40h384
c22.1,0,40-17.9,40-40V256C488,242.7,477.3,232,464,232z" fill="#FC7D85" />
                    </g>
                </svg>
    </xsl:template>
    
</xsl:stylesheet>       