<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:text="http://ametys.org/text/3.0" 
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              exclude-result-prefixes="docbook resolver"
                              extension-element-prefixes="text">
    
	<xsl:import href="skin://stylesheets/content/common-abstract.xsl"/>
	
	<xsl:variable name="common-content-css-class-name"> abstract-view job-offer ametys-mb-20 </xsl:variable>
    
    <xsl:template name="content-default-image">
        <span class="icon icofont-search-job"></span>
    </xsl:template>
    
    <xsl:template name="content-ctype">
        <h2 class="ametys-document__txt_name">
            <i18n:text i18n:key="SKIN_CONTENT_TYPE_JOB_OFFER" i18n:catalogue="skin.{$skin}"/>
        </h2>
    </xsl:template>
    
    <xsl:template name="content-dates">
        <xsl:if test="metadata/closingDate">
            <span class="ametys-document_icn font-italic">
                <i class="material-icons">access_time</i>
                    <i18n:text i18n:key="CONTENT_VIEW_DEADLINE" i18n:catalogue="skin.{$skin}"/>
                    <xsl:text> </xsl:text> 
                    <xsl:call-template name="common-utils-date-pattern">
                        <xsl:with-param name="date" select="metadata/closingDate"/>
                    </xsl:call-template>                
            </span>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>
