<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	    xmlns:docbook="http://docbook.org/ns/docbook"
	    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
	    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
	    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
	    xmlns:text="http://ametys.org/text/3.0" 
	    xmlns:exslt="http://exslt.org/common"
	    exclude-result-prefixes="docbook resolver ametys exslt"
	    xmlns:datetime="http://ametys.org/datetime/4.2"
	    extension-element-prefixes="datetime text">

	<xsl:import href="plugin:news://stylesheets/content/news/news-abstract.xsl"/>	
	<xsl:import href="skin://stylesheets/content/common-abstract.xsl"/>
	<xsl:import href="skin://stylesheets/utils.xsl" />
	
    <xsl:variable name="abstractTextMaxSize">300</xsl:variable>
    
	<xsl:variable name="common-content-css-class-name"> home-view news </xsl:variable>
	
	<xsl:template name="common-content-body-title"/>
	
	<xsl:template name="common-content-body-content">
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        <xsl:choose>
            <xsl:when test="$page-id != ''">
                <a href="{resolver:resolve('page', $page-id, false)}" class="ametys-news-agenda__link">
                    <xsl:call-template name="content"/>
                </a>
            </xsl:when>
            <xsl:otherwise>
                <div class="ametys-news-agenda__link">
                    <xsl:call-template name="content"/>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
	
	<xsl:template name="content">
        <article>
            <xsl:call-template name="content-image"/>
            <div class="ametys-news-agenda__link__info ametys-document__txt--limit">
                <xsl:call-template name="content-dates"/>
            
                <xsl:call-template name="content-badge"/>
            
                <xsl:call-template name="content-title"/>
            </div>
        </article>
    </xsl:template>
    
    <xsl:template name="content-image">
        <xsl:choose>
            <xsl:when test="metadata/illustration/image">
                <!-- Image -->
                <xsl:call-template name="common-content-body-image">
                    <xsl:with-param name="image" select="metadata/illustration/image"/>
                    <xsl:with-param name="alternative" select="metadata/illustration/alt-text"/>
                    <xsl:with-param name="maxWidth" select="'240'"/>
                    <xsl:with-param name="maxHeight" select="'150'"/>
                    <xsl:with-param name="class" select="'ametys-news-agenda__link_img'"/>
                    <xsl:with-param name="type" select="'cropped'"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="content-default-image"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="content-default-image">
        <div class="content-illustration ametys-news-agenda__link_img">
            <span class="icofont-newspaper"></span>
        </div>
    </xsl:template>
    
    <xsl:template name="content-title">
        <h2 class="ametys-news-agenda__title">
            <xsl:value-of select="metadata/title"/>
        </h2>
    </xsl:template>
    
    <xsl:template name="content-dates">
        <xsl:if test="metadata/start-date or metadata/end-date">
            <span class="ametys-news-agenda__date">
                <xsl:call-template name="content-date-format">
	            	<xsl:with-param name="date" select="metadata/start-date"/>
	            </xsl:call-template>
	            
	            <xsl:if test="metadata/start-date and metadata/end-date and not(datetime:sameDate(metadata/start-date, metadata/end-date))">
                  <!-- case when the two datetimes represent the same date -->
	              <xsl:call-template name="content-date-format">
	            	<xsl:with-param name="date" select="metadata/end-date"/>
	            	<xsl:with-param name="class" select="'end'"/>
	              </xsl:call-template>
	            </xsl:if>
            </span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-date-format">
        <xsl:param name="date"/>
        <xsl:param name="class" select="'start'"/>
        
         <span class="ametys-news-agenda__date__{$class}">
             <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="d">
                 <xsl:value-of select="$date"/>
             </i18n:date>
           <span class="ametys-news-agenda__date__{$class}__month">
             <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="MMM">
                 <xsl:value-of select="$date" />
             </i18n:date>
           </span>
         </span>
    </xsl:template>
    
    <xsl:template name="content-badge">
        <xsl:variable name="tags"><xsl:call-template name="get-content-tags"/></xsl:variable>
        
        <xsl:if test="exslt:node-set($tags)/tag">
        <div class="ametys-news-agenda__tags">
	        <xsl:for-each select="exslt:node-set($tags)/tag">
	           <span class="ametys-news-agenda__tags__tag">
	               <xsl:if test="$useTagColor and @bgColor">
                       <xsl:attribute name="style">background-color: <xsl:value-of select="@bgColor"/>; color: <xsl:value-of select="@textColor"/></xsl:attribute>
                    </xsl:if>
	               <xsl:value-of select="."/>
	           </span>
	        </xsl:for-each>
	    </div>
	    </xsl:if>
     </xsl:template>
    
</xsl:stylesheet>