<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:text="http://ametys.org/text/3.0" 
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              exclude-result-prefixes="docbook resolver"
                              extension-element-prefixes="text">
    
    <xsl:import href="plugin:multimedia://stylesheets/content/video/video-abstract.xsl"/>		
	<xsl:import href="skin://stylesheets/content/common-abstract.xsl"/>
    
	<xsl:variable name="common-content-css-class-name">abstract-view video ametys-mb-20</xsl:variable>
	
    <xsl:template name="content-ctype">
        <h2 class="ametys-document__txt_name">
            <i18n:text i18n:key="SKIN_CONTENT_TYPE_VIDEO" i18n:catalogue="skin.{$skin}"/>
        </h2>
    </xsl:template>
    
    <xsl:template name="content-image">
        <xsl:choose>
            <xsl:when test="metadata/illustration/image">
                <div class="ametys-video--play">
                    <!-- Image -->
                    <xsl:call-template name="common-content-body-image">
                        <xsl:with-param name="image" select="metadata/illustration/image"/>
                        <xsl:with-param name="alternative" select="metadata/illustration/alt-text"/>
                        <xsl:with-param name="maxWidth" select="'488'"/>
                        <xsl:with-param name="maxHeight" select="'328'"/>
                        <xsl:with-param name="type" select="'cropped'"/>
                    </xsl:call-template>
                    <xsl:call-template name="content-default-image"/>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="content-default-image"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="content-default-image">
        <span class="icon icofont-ui-play"></span>
    </xsl:template>
    
</xsl:stylesheet>
