<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        extension-element-prefixes="resolver">
    
    <xsl:import href="skin://services/syndication/pages/services/feed/feed2xhtml_1.2.xsl"/>
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/index-timeline/scss/main.css')}" media="screen, print, handheld"/>   
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/index-timeline/scss/print.css')}" media="print"/>
        
        <xsl:if test="ametys:renderingContext() = 'back'">
            <link href="{ametys:pluginResourceURL('syndication', 'css/bo-error.css')}" rel="stylesheet" type="text/css" />
        </xsl:if>    
    </xsl:template>       
    
    <xsl:template name="body-class-attribute">
        <xsl:attribute name="class">card-body pt-0</xsl:attribute>
    </xsl:template>    
    
    <xsl:template name="list-class-attribute">
        <xsl:attribute name="class">ametys-timeline</xsl:attribute>
    </xsl:template>
        
    <xsl:template name="card-header-icon">
        <span class="card-header__icon material-icons access_time"></span>
    </xsl:template>
    
    <xsl:template match="entry" mode="class-attribute">
        <xsl:attribute name="class">ametys-timeline__item</xsl:attribute>
    </xsl:template> 
    
    <xsl:template match="entry" mode="link-attribute">
        <xsl:attribute name="class">ametys-timeline__link</xsl:attribute>
    </xsl:template> 
    
    <xsl:template match="entry" mode="body">
        <article>
            <xsl:apply-templates select="." mode="date"/>  
            
            <div class="ametys-timeline__item-description">
               <xsl:apply-templates select="." mode="title"/>       
               <xsl:apply-templates select="." mode="description"/>  
            </div>
        </article>
    </xsl:template>   
    
    <xsl:template match="entry" mode="title">  
        <span class="ametys-timeline__item-title">
            <xsl:value-of select="@title"/>
        </span>
    </xsl:template>
    
    <xsl:template match="entry" mode="description">  
        <xsl:if test="description">
            <p class="text-truncate">
                <xsl:choose>
                    <xsl:when test="'text/html'">
                        <xsl:value-of select="description" disable-output-escaping="yes"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="description"/>
                    </xsl:otherwise>
                </xsl:choose>
            </p>
        </xsl:if>    
    </xsl:template>
    
    <xsl:template match="entry" mode="date">    
        <div class="ametys-timeline__item-date">
            <xsl:if test="@date">
                <span class="ametys-timeline__item-day">
                    <i18n:date src-pattern="yyyy-MM-dd" pattern="dd MMM"><xsl:value-of select="@date"/></i18n:date>
                </span>
                <span class="ametys-timeline__item-year">
                    <i18n:date src-pattern="yyyy-MM-dd" pattern="yyyy"><xsl:value-of select="@date"/></i18n:date>
                </span>
            </xsl:if>
        </div>
    </xsl:template>
    
    
</xsl:stylesheet>       
