<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="java.lang.Math"
                xmlns:ugc="org.ametys.plugins.ugc.transformation.xslt.UgcXSLTHelper"
                exclude-result-prefixes="resolver math ametys ugc">
                
    <xsl:import href="common/home-card-search.xsl"/>
    
    <xsl:template name="common-service-head-css">    
         <link rel="stylesheet" href="{ametys:skinURL('zones/index-advertisement/scss/main.css')}" />
	    <link rel="stylesheet" href="{ametys:skinURL('zones/index-advertisement/scss/print.css')}" />
    </xsl:template>
    
    <xsl:variable name="common-service-css-class-name"> ametys-cms-zone-advertisement </xsl:variable>
    
    <xsl:template name="hits-class-attribute">
        <xsl:attribute name="class">ametys-advertisement</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>ametys-advertisement__item<xsl:text> </xsl:text>
    </xsl:template>           
    
    <xsl:template name="header-default">
        <i18n:text i18n:key="SKIN_ADS" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template name="card-header-icon">
        <i class="card-header__icon material-icons grain"></i>
    </xsl:template>
    
    <xsl:template name="link-default-title">
        <i18n:text i18n:key="SKIN_ADS_PUBLICATION_LABEL" i18n:catalogue="skin.{$skin}"/>
   </xsl:template>
   
   <xsl:template name="hit">
        <li>
            <xsl:call-template name="hit-attributes"/>
            <xsl:apply-templates select="content/html" mode="content"/>
        </li>
    </xsl:template>
    
    <xsl:template match="html" mode="content">
        <xsl:variable name="pageId" select="ugc:getUgcPage(../@id)"/>
        <xsl:choose>
			<xsl:when test="$pageId != ''">
				<a class="ametys-advertisement__link" href="{resolver:resolve('page', $pageId)}">
					<xsl:apply-templates select="." mode="inner-content"/>
				</a>
			</xsl:when>
			<xsl:otherwise>
				<div class="ametys-advertisement__link">
					<xsl:apply-templates select="." mode="inner-content"/>
				</div>
			</xsl:otherwise>
		</xsl:choose>
    </xsl:template>
    
    <xsl:template match="html" mode="inner-content">
        <article>
            <xsl:apply-templates select="." mode="image"/>
            <div>
                <xsl:apply-templates select="." mode="category"/>
                <xsl:apply-templates select="." mode="title"/>
                <xsl:apply-templates select="." mode="date"/>
            </div>
        </article>
        
    </xsl:template>
    
    <xsl:template match="html" mode="image">
        <xsl:variable name="imgType" select="head/meta[@name = 'illustrations/image1;type']/@content"/>        
        <xsl:variable name="imgPath" select="head/meta[@name = 'illustrations/image1;path']/@content"/>
        <xsl:variable name="imgUrl"><xsl:value-of select="$imgPath"/><xsl:if test="$imgType = 'attribute'">?contentId=<xsl:value-of select="../@id"/></xsl:if></xsl:variable>
        
        <div class="ametys-advertisement__link_img">
            <xsl:choose>
                <xsl:when test="$imgType != ''">
                    <img src="{resolver:resolveCroppedImage($imgType, $imgUrl, '88', '129')}" alt=""/>
                </xsl:when>
                <xsl:otherwise>
                    <div class="ametys-document__img"/>
                </xsl:otherwise>
            </xsl:choose>
            
            <xsl:apply-templates select="." mode="price"/>
        </div>
    </xsl:template>
    
    <xsl:template match="html" mode="price">
        <xsl:variable name="price" select="head/meta[@name = 'price']/@content"/>
        
        <xsl:if test="$price != ''">
            <xsl:choose>
                <xsl:when test="contains($price, '.0')">
                    <span class="ametys-advertisement__link_img_price"><xsl:value-of select="substring-before($price, '.0')"/> €</span>
                </xsl:when>
                <xsl:otherwise>
                    <span class="ametys-advertisement__link_img_price"><xsl:value-of select="translate($price, '.', ',')"/> €</span>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="html" mode="title">
        <xsl:variable name="title" select="head/meta[@name = 'title']/@content"/>
        
        <h2 class="ametys-advertisement__title">
		    <xsl:value-of select="$title" />
		</h2>
    </xsl:template>
    
    <xsl:template match="html" mode="date">
        <xsl:variable name="lastValidatedAt" select="head/meta[@name = 'lastValidatedAtRaw']/@content"/>
        
        <xsl:if test="$lastValidatedAt != ''">
            <span class="ametys-date font-italic">
                <span class="ametys-date__icon material-icons access_time"></span>
                Publication
                <xsl:text> </xsl:text>
                <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="medium"><xsl:value-of select="$lastValidatedAt"/></i18n:date>
            </span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="html" mode="category">
        <xsl:variable name="category" select="head/meta[@name='category;title']/@content"/>
        
        <xsl:if test="$category != ''">
            <span class="ametys-advertisement__cat"><xsl:value-of select="$category"/></span>
        </xsl:if>
    </xsl:template>
    
    
    <xsl:template name="header">
        <header class="card-header card-header--space-between">
            <h1 class="card-title">
                <xsl:call-template name="card-header-icon"/>
                
                <xsl:choose>
                    <xsl:when test="$header != ''">
                        <xsl:value-of select="$header"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="header-default"/>
                    </xsl:otherwise>
                </xsl:choose>
            </h1>
            <div class="card-right">
	            <xsl:call-template name="publish-ads"/> 
	            <xsl:call-template name="link"/>
            </div>
        </header>
   </xsl:template>
   
   <xsl:template name="publish-ads">
       <xsl:variable name="postPage" select="ametys:findPagesIdsByTag('PUBLICATION')"/>
       <xsl:if test="$postPage">
           <a href="{resolver:resolve('page', $postPage/@id)}" class="card-btn">  
               <i class="icon-container fas fa-pen"></i>
               <span><i18n:text i18n:key="SKIN_CONTENT_ADS_PUBLISH_LABEL" i18n:catalogue="skin.{$skin}"/></span>
           </a>
      </xsl:if>
   </xsl:template>
	
</xsl:stylesheet>
