<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        xmlns:url="org.ametys.core.util.URIUtils"
        xmlns:filename="org.ametys.core.util.FilenameUtils"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        xmlns:stringutils="org.apache.commons.lang.StringUtils"
        exclude-result-prefixes="ametys resolver escaper stringutils url filename"> 
        
    <xsl:import href="plugin:web://pages/services/search/search-default/results/search-results.xsl"/>

    <!-- Override rendering for resource hits -->
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ResourceSaxer']">
        <xsl:attribute name="class">
            <xsl:apply-templates select="." mode="class-attribute"/>
        </xsl:attribute>
        
        <div class="ametys-cms-content ametys-mb-20">
            <a class="ametys-document flex-column ametys-document--frame">
                <xsl:attribute name="href"><xsl:call-template name="hit-resource-title-link-href"/></xsl:attribute>
                
                <xsl:apply-templates select="." mode="content"/>
            </a>
        </div>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ResourceSaxer' or @saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer']" mode="content">
        <div class="ametys-document__img ametys-document__img--play">
            <xsl:apply-templates select="." mode="image"/>
        </div>
        <div class="ametys-document__txt ametys-document__txt--limit">
            <xsl:apply-templates select="." mode="ctype"/>
            
            <xsl:apply-templates select="." mode="date"/>
            
            <xsl:apply-templates select="." mode="title"/>
        
            <xsl:apply-templates select="." mode="abstract"/>
        </div>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ResourceSaxer']" mode="image">
        <span class="icon icofont-ui-copy"></span>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ResourceSaxer']" mode="ctype">
        <h3 class="ametys-document__txt_name">
            <i18n:text i18n:key="SKIN_CONTENT_TYPE_DOCUMENT" i18n:catalogue="skin.{$skin}"/>
        </h3>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ResourceSaxer']" mode="title">
        <h2 class="ametys-document__txt_title">
            <xsl:value-of select="filename"/>
        </h2>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ResourceSaxer' or @saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer']" mode="abstract">
        <xsl:variable name="truncatedText">
            <xsl:call-template name="common-utils-simpletext">
                <xsl:with-param name="defaultText" select="excerpt"/>                
                <xsl:with-param name="maxDefaultTextSize" select="'80'"/>                
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:if test="normalize-space($truncatedText) != ''">
            <p class="ametys-document__paragraph">
                <xsl:copy-of select="$truncatedText"/>           
            </p>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ResourceSaxer']" mode="date">
        <span class="ametys-document_icn font-italic">
            <i class="material-icons">access_time</i>
            <i18n:text i18n:key="CONTENT_VIEW_LASTPUBLICATIONDATE" i18n:catalogue="skin.{$skin}"/>
            
            <xsl:text> </xsl:text> 
            <xsl:call-template name="common-utils-date-pattern">
                <xsl:with-param name="date" select="lastModified"/>
            </xsl:call-template>                
        </span>    
    </xsl:template>
    <!-- // End resource hits -->
    
    <!-- Override rendering for page hits -->
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer']">
        <xsl:attribute name="class">
            <xsl:apply-templates select="." mode="class-attribute"/>
        </xsl:attribute>
        
        <div class="ametys-cms-content ametys-mb-20">
            <a class="ametys-document flex-column ametys-document--frame">
                <xsl:attribute name="href"><xsl:call-template name="hit-page-title-href"/></xsl:attribute>
                
                <xsl:apply-templates select="." mode="content"/>
            </a>
        </div>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer']" mode="image">
        <span class="icon icofont-paper"></span>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer']" mode="ctype">
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer']" mode="title">
        <h2 class="ametys-document__txt_title">
            <xsl:value-of select="title"/>
        </h2>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer']" mode="date">
    </xsl:template>
    <!-- // End page hits -->
</xsl:stylesheet>