<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:text="http://ametys.org/text/3.0" 
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:ugc="org.ametys.plugins.ugc.transformation.xslt.UgcXSLTHelper"   
                              exclude-result-prefixes="docbook resolver"
                              extension-element-prefixes="text ugc">

	<xsl:import href="plugin:classified-ads://stylesheets/content/ads/ads-abstract.xsl"/>	
	<xsl:import href="skin://stylesheets/content/common-abstract.xsl"/>
	
	<xsl:template name="common-content-body-title"/>
	
    <xsl:template name="content-image">
        <xsl:choose>
            <xsl:when test="metadata/illustrations/image1">
                <!-- Image -->
                <xsl:call-template name="common-content-body-image">
                    <xsl:with-param name="image" select="metadata/illustrations/image1"/>
                    <xsl:with-param name="alternative" select="metadata/illustrations/image1/alt-text"/>
                    <xsl:with-param name="maxWidth" select="'488'"/>
                    <xsl:with-param name="maxHeight" select="'328'"/>
                    <xsl:with-param name="class" select="'ametys-document__img ametys-document__img--play'"/>
                    <xsl:with-param name="type" select="'cropped'"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <div class="ametys-document__img ametys-document__img--play">
                    <xsl:call-template name="content-default-image"/>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="content-badge">
        <span class="ametys-document__img_badge">
            <xsl:value-of select="metadata/category/@title"/>
        </span>
        
        <xsl:if test="metadata/price != ''">
            <xsl:choose>
                <xsl:when test="contains(metadata/price, '.0')">
                    <span class="ametys-document__img_price"><xsl:value-of select="substring-before(metadata/price, '.0')"/> €</span>
                </xsl:when>
                <xsl:otherwise>
                    <span class="ametys-document__img_price"><xsl:value-of select="translate(metadata/price, '.', ',')"/> €</span>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-default-image">
        <span class="icon icofont-cart-alt"></span>
    </xsl:template>
    
    <xsl:template name="content-ctype">
        <h2 class="ametys-document__txt_name">
            <i18n:text i18n:key="SKIN_CONTENT_TYPE_ADS" i18n:catalogue="skin.{$skin}"/>
        </h2>
    </xsl:template>
    
    <xsl:template name="content-dates"/>
    
    <xsl:template name="get-page-id">
        <xsl:value-of select="ugc:getUgcPage(//content/@id)"/>
    </xsl:template>
	
</xsl:stylesheet>
