<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							  xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:text="http://ametys.org/text/3.0" 
                              exclude-result-prefixes="ametys docbook resolver"
                              extension-element-prefixes="text">

     <xsl:import href="skin://stylesheets/content/common.xsl"/>
     
     <xsl:variable name="abstractTextMaxSize">300</xsl:variable>
     
     <xsl:variable name="common-content-css-class-name">ametys-abonnement-list-item</xsl:variable>
     
     <xsl:template name="common-content-body-title"/>
     
    <xsl:template name="common-content-body-content">
        
        <xsl:call-template name="content-image"/>
        
        <div class="infos">
            <xsl:call-template name="content-title"/>
            
            <xsl:call-template name="content-abstract"/>
            
            <div class="actions">
                <xsl:call-template name="content-link"/>
                <xsl:call-template name="content-actions"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="content-link">
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        
        <xsl:if test="$page-id != ''">
            <a href="{resolver:resolve('page', $page-id, false)}">
                <i class="fas fa-external-link-alt" aria-hidden="true"></i>
                <i18n:text i18n:key="SKIN_CONTENT_VIEW_SUBSCRIPTION_READ_MORE" i18n:catalogue="skin.{$skin}"/>
            </a>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-actions">
        <!-- Not yet implemented -->
        <!-- <div class="sub-action">
            <xsl:call-template name="content-views"/>
            <xsl:call-template name="content-likes"/>
        </div> -->
    </xsl:template>
    
    <xsl:template name="content-views">
        <span class="view"><i class="fas fa-eye" aria-hidden="true"></i> 13 vues</span>
    </xsl:template>
    
    <xsl:template name="content-likes">
        <button class="like">
            <i class="far fa-thumbs-up" aria-hidden="true"></i> <span class="nb">3</span>
        </button>
    </xsl:template>
    
    <xsl:template name="content-image">
        <xsl:choose>
            <xsl:when test="metadata/illustration/image">
                <!-- Image -->
                <xsl:call-template name="common-content-body-image">
                    <xsl:with-param name="image" select="metadata/illustration/image"/>
                    <xsl:with-param name="alternative" select="metadata/illustration/alt-text"/>
                    <xsl:with-param name="maxWidth" select="226"/>
                    <xsl:with-param name="maxHeight" select="130"/>
                    <xsl:with-param name="type" select="'cropped'"/>
                    <xsl:with-param name="class">picture</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="content-default-image"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="content-default-image">
    </xsl:template>
    
    <xsl:template name="content-title">
        <h2 class="title"><xsl:value-of select="metadata/title"/></h2>
    </xsl:template>
    
    <xsl:template name="content-abstract">
        <xsl:call-template name="common-content-body-simpletext">
            <xsl:with-param name="css-class-name">description</xsl:with-param>
            <xsl:with-param name="text" select="metadata/abstract" />
            <xsl:with-param name="defaultText" select="metadata/content/docbook:article" />
            <xsl:with-param name="maxDefaultTextSize" select="$abstractTextMaxSize" />
        </xsl:call-template>
    </xsl:template>
	
</xsl:stylesheet>
    