(function($) {
  function showOverlay() {
    $('.ametys-overlay').fadeIn(400);
  }

  function hideOverlay() {
    $('.ametys-overlay').fadeOut(400);
  }

  function toggleSidebar(e) {
    $(e.currentTarget).toggleClass('active');
    $(e.currentTarget.dataset.targetHide).toggleClass('sidebar-is-toggled');

    $('.ametys-header-logo-wrap').addClass('ametys-header-logo-wrap_invisible');

    $('#sidebar').on('transitionend webkitTransitionEnd oTransitionEnd otransitionend MSTransitionEnd', function () {
      $('.ametys-header-logo-wrap').removeClass('ametys-header-logo-wrap_invisible');
    });
  }

  function toggleElement(e) {
    $(e.currentTarget).toggleClass('active');
    $(e.currentTarget.dataset.targetHide).fadeToggle(200);

    if(e.currentTarget.dataset.targetShow) {
      $(e.currentTarget.dataset.targetShow).fadeToggle(200);
    }
  }

  $().ready(function () {
	    var windowWidth = window.innerWidth;

    if($('.ametys-header-search-invoker').length) {

	    if(windowWidth <= 768) {
	      document.querySelector('.ametys-header-search-invoker').addEventListener('click', toggleElement);
	      document.querySelector('.ametys-header-action-invoker').addEventListener('click', toggleElement);
	    } else {
	      document.querySelector('.ametys-header-search-invoker').removeEventListener('click', toggleElement);
	      document.querySelector('.ametys-header-action-invoker').removeEventListener('click', toggleElement);
	    }

    }

    if($('.ametys-header-invoker').length) {
  
      document.querySelector('.ametys-header-invoker').addEventListener('click', toggleSidebar);
    
	    if(windowWidth <= 991) {
	      document.querySelector('.ametys-header-invoker').addEventListener('click', showOverlay);
	      document.querySelector('.ametys-overlay').addEventListener('click', toggleSidebar);
	      document.querySelector('.ametys-overlay').addEventListener('click', hideOverlay);
	    } else {
	      document.querySelector('.ametys-header-invoker').removeEventListener('click', showOverlay);
	      document.querySelector('.ametys-overlay').removeEventListener('click', toggleSidebar);
	      document.querySelector('.ametys-overlay').removeEventListener('click', hideOverlay);
	    }
  
    }
    
	

	  $(window).on('resize', function() {
	    var windowWidth = window.innerWidth;

    if($('.ametys-header-search-invoker').length) {
  
	    if(windowWidth <= 768) {
	      document.querySelector('.ametys-header-search-invoker').addEventListener('click', toggleElement);
	      document.querySelector('.ametys-header-action-invoker').addEventListener('click', toggleElement);
	    } else {
	      document.querySelector('.ametys-header-search-invoker').removeEventListener('click', toggleElement);
	      document.querySelector('.ametys-header-action-invoker').removeEventListener('click', toggleElement);
	    }

    }
  
    if($('.ametys-header-invoker').length) {
  
	    if(windowWidth <= 991) {
	      document.querySelector('.ametys-header-invoker').addEventListener('click', showOverlay);
	      document.querySelector('.ametys-overlay').addEventListener('click', toggleSidebar);
	      document.querySelector('.ametys-overlay').addEventListener('click', hideOverlay);
	    } else {
	      document.querySelector('.ametys-header-invoker').removeEventListener('click', showOverlay);
	      document.querySelector('.ametys-overlay').removeEventListener('click', toggleSidebar);
	      document.querySelector('.ametys-overlay').removeEventListener('click', hideOverlay);
	    }
  
    }
    
	  });
    
	  });

})(jQuery);