<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:linkDirectory="org.ametys.plugins.linkdirectory.LinkDirectoryXSLTHelper">

    <xsl:import href="skin://services/link-directory/pages/services/directory/directory_1.0.xsl"/>
    
    <xsl:template name="card-header-default-title">
        <i18n:text i18n:key="SERVICE_SEARCH_XSLT_DOWNLOAD_LABEL" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template name="card-header-icon">
		<span class="card-header__icon icofont-download-alt"></span>
	</xsl:template>
    
    <xsl:template name="link-title">
        <div class="{$cssClassPrefix}__description">
            <h2 class="{$cssClassPrefix}__title"><xsl:value-of select="@title"/></h2>
            <span class="ametys-links__cat">Consulter</span>
        </div>
    </xsl:template>
    
    <xsl:template name="link-picture">
        <xsl:param name="cssClassPrefix"/>
        <xsl:param name="height">100</xsl:param>
        <xsl:param name="width">100</xsl:param>
        
        <xsl:choose>
            <xsl:when test="@pictureType != ''">
                <div class="{$cssClassPrefix}__icon ametys-square-icon">
                    <xsl:call-template name="link-status" />
                    
                    <span class="{$cssClassPrefix}__action"></span>
                    <xsl:choose>
                        <xsl:when test="@pictureType = 'glyph'">
                            <span class="ametys-square-icon__icon {$cssClassPrefix}__icon-content link-glyph {@pictureGlyph}"></span>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:variable name="id">
                                <xsl:choose>
                                    <xsl:when test="@pictureType = 'resource'">
                                        <xsl:value-of select="@pictureId"/>
                                    </xsl:when>
                                    <xsl:when test="@pictureType = 'external'">
                                        <xsl:value-of select="concat(@picturePath, '?objectId=', @id)"/>
                                    </xsl:when>
                                </xsl:choose>
                            </xsl:variable>
                            <img class="svg" src="{resolver:resolveBoundedImage(@imageType, $id, $height, $width)}" alt="{@pictureAlternative}"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </div>
             </xsl:when>
             <xsl:otherwise>
                <!-- No picture -->
                <xsl:call-template name="link-picture-default">
                    <xsl:with-param name="cssClassPrefix" select="$cssClassPrefix"/>
                </xsl:call-template>
             </xsl:otherwise>
         </xsl:choose>
    </xsl:template>
    
    
</xsl:stylesheet>       
