<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:xalan="http://xml.apache.org/xalan"
							xmlns:math="java.lang.Math"
							xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="sitemap resolver ametys">

	<xsl:import href="skin://stylesheets/search.xsl" />
	<xsl:import href="wa://tracking" />
    <xsl:import href="plugin:web://stylesheets/helper/fastsearch.xsl"/>
    <xsl:import href="plugin:rocket.chat?://stylesheets/rocket.chat.xsl" />
    
	<!-- + 
	     | HEAD
	     + -->
	<xsl:template name="head">
		<head>
			<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
			<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
			<title><xsl:call-template name="get-title"/></title>

				<xsl:call-template name="meta" />
				<xsl:call-template name="og-meta" />
                
                <xsl:call-template name="head-translations"/>

				<xsl:call-template name="common-css" />
				<xsl:call-template name="additionnal-css" />

				<xsl:call-template name="common-rss" />
				<xsl:call-template name="additionnal-rss" />

				<xsl:call-template name="common-script" />
				<xsl:call-template name="additionnal-script" />
                 
				<xsl:call-template name="front-edition-css"/>
				
   	            <!-- Search  -->
                <xsl:call-template name="search-head"/>
                
                <xsl:call-template name="web-tracking"/>
   		</head>
	</xsl:template>
	
	<xsl:template name="front-edition-css"/>
	
	<xsl:template name="get-title">
		<xsl:choose>
			<xsl:when test="/cms/page"><xsl:value-of select="/cms/page/@long-title" /><xsl:text> - </xsl:text></xsl:when>
			<xsl:when test="/cms/html/head/title"><xsl:value-of select="/cms/html/head/title" /><xsl:text> - </xsl:text></xsl:when>
		</xsl:choose>
		<i18n:text i18n:key="SKIN_TITLE" i18n:catalogue="skin.{$skin}"/>
	</xsl:template>
	
	<!-- + 
	     | META
	     + -->
	<xsl:template name="meta">
		<meta name="author" content="Ametys V4" />
        <meta name="copyright" content="Ametys V4" />
		<meta name="language" content="{$lang}" />
		<meta name="revisit-after" content="15 days" />
	 	
        <xsl:if test="/cms/page/pageContents/zone[@name = 'default']/zoneItem/html/head/meta[@name = 'DC.subject']">
    	 	<meta name="subject" content="{/cms/page/pageContents/zone/zoneItem/html/head/meta[@name = 'DC.subject']/@content}"/>
    	</xsl:if>
	 	
        <xsl:if test="/cms/page/pageContents/zone[@name = 'default']/zoneItem/html/head/meta[@name = 'DC.description']">
    		<meta name="description" content="{/cms/page/pageContents/zone/zoneItem/html/head/meta[@name = 'DC.description']/@content}"/>
    	</xsl:if>
        
        <!-- Copy Dublin Core metadata. -->
        <xsl:copy-of select="/cms/page/pageContents/zone[@name = 'default']/zoneItem/html/head/meta[starts-with(@name, 'DC.')]"/>
	</xsl:template>
	
	<!-- + 
         | OPEN GRAPH META
         + -->
	<xsl:template name="og-meta">
		<xsl:comment>
			<xsl:for-each select="/cms/page/pageContents/zone[@name = 'default']/zoneItem[information/type = 'CONTENT'][1]/html/head">
					<meta property="og:title" content="{meta[@name = 'DC.title']/@content}" />
					<xsl:if test="meta[@name = 'DC.description']">
						<meta property="og:description" content="{meta[@name = 'DC.description']/@content}" />
					</xsl:if>
					<xsl:if test="meta[@name = 'DC.type']">
						<meta property="og:type" content="{meta[@name = 'DC.type']/@content}" />
					</xsl:if>
			</xsl:for-each>
		</xsl:comment>
	</xsl:template>
	
    <xsl:template name="head-css-jquery">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/plugins/jquery/jquery-ui-1.11.4.css')}" media="screen, print, handheld"/>
    </xsl:template>
    
	<xsl:template name="common-css">
		<link rel="stylesheet" href="{ametys:skinURL('templates/common/fonts/din-pro/scss/stylesheet.css')}" />
    	<link rel="stylesheet" href="{ametys:skinURL('templates/common/fonts/gotham/stylesheet.css')}" />
    	<link rel="stylesheet" href="{ametys:skinURL('templates/common/fonts/material-design-icons/iconfont/material-icons.css')}" />
    	<link rel="stylesheet" href="{ametys:skinURL('templates/common/fonts/icofont/icofont.css')}" />
		<link rel="stylesheet" href="{ametys:skinURL('templates/common/fonts/Encode_Sans_Condensed/stylesheet.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/fonts/intranet/IntranetIcon.css')}"/>
		<link rel="stylesheet" href="{ametys:pluginResourceURL('fontawesome6-free', 'css/all.css')}" />
		<link rel="stylesheet" href="{ametys:skinURL('templates/common/fonts/icon-hs/style.css')}" />
		
		<link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/animate.css')}" />
		<link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/malihu-scrollbar/jquery.mCustomScrollbar.css')}" />
		
		<link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/slick-carousel/slick/slick.css')}" />
		<link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/fancybox/jquery.fancybox.css')}" />
		<link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/chosen/chosen.css')}" />
		<link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/bootstrap-select/dist/css/bootstrap-select.css')}" />
		<!-- More styles -->
		
		<!-- Weather Zone -->
	    <link rel="stylesheet" href="{ametys:skinURL('zones/weather/scss/main.css')}"/>
	    <!-- End Weather Zone -->
    
		<!-- Main Styles -->
		<link rel="stylesheet" href="{ametys:skinURL('templates/common/scss/main.css')}" />
		<link rel="stylesheet" href="{ametys:skinURL('templates/common/scss/print.css')}" />
		<!-- End Main Styles -->
		
		<!-- Main Styles -->
		<link rel="stylesheet" href="{ametys:skinURL('templates/common/scss/ametys.css')}"/>
        
        <xsl:call-template name="rocket.chat-css">
            <xsl:with-param name="only-dependencies" select="true()"/>
        </xsl:call-template>

        <xsl:call-template name="custom-css"/>
		
		<xsl:call-template name="head-css-fancybox"/>
	</xsl:template>
    
    <!-- + 
         | CUSTOM CSS / ADDITIONAL FONTS
         + -->
    <xsl:template name="custom-css">
        <!-- Insert your custom css here (ex: additional fonts )-->
    </xsl:template>

	<!-- + 
         | ADDITIONNAL CSS
         + -->
	<xsl:template name="additionnal-css"/>


	<!-- + 
         | COMMON RSS
         + -->
	<xsl:template name="common-rss"/>

	<!-- + 
         | ADDITIONNAL RSS
         + -->
	<xsl:template name="additionnal-rss"/>
		
	<!-- + 
         | COMMON SCRIPT
         + -->
	<xsl:template name="common-script">
        <!-- Accessibility switch -->
        <xsl:if test="$conf-layout-accessibility-css = 'true'">
         <script type="text/javascript">
             var accessibilitySwitchNormalLabel = "<i18n:text i18n:key="SKIN_ACCESSIBILITYSWITCH_SWITCHTONORMAL" i18n:catalogue="skin.{$skin}"/>";
             var accessibilitySwitchAccessibleLabel = "<i18n:text i18n:key="SKIN_ACCESSIBILITYSWITCH_SWITCHTOACCESSIBLE" i18n:catalogue="skin.{$skin}"/>";
         </script>
         <script type="text/javascript" src="{ametys:skinURL('templates/common/js/accessibilityswitch.js')}"></script>
        </xsl:if>
        
        <script src="{ametys:skinURL('templates/common/plugins/jquery-resize/jquery.ba-resize.js')}"></script>
		<script src="{ametys:skinURL('templates/common/plugins/popper.js/dist/umd/popper.js')}"></script>
		<script src="{ametys:skinURL('templates/common/plugins/tooltip.js/dist/umd/tooltip.js')}"></script>
		<script src="{ametys:skinURL('templates/common/plugins/bootstrap/bootstrap.min.js')}"></script>
		<script src="{ametys:skinURL('templates/common/plugins/malihu-scrollbar/jquery.mCustomScrollbar.js')}"></script>
		<script src="{ametys:skinURL('templates/common/plugins/slick-carousel/slick/slick.js')}"></script>
		<script src="{ametys:skinURL('templates/common/plugins/chosen/chosen.jquery.js')}"></script>
		
		<xsl:call-template name="rocket.chat-scripts"/>
        
        <!-- jQuery migrate 3.3.1 -->
	    <script type="text/javascript" src="{ametys:skinURL('templates/common/plugins/jquery-migrate/jquery-migrate-3.5.2.js')}"></script>
        <script>
            $j.migrateMute = true;
        </script>
        
        <xsl:call-template name="head-js-fancybox"/>
        
		<script src="{ametys:skinURL('templates/common/plugins/bootstrap-select/dist/js/bootstrap-select.js')}"></script>
		
		<script src="{ametys:skinURL('templates/common/js/hs.core.js')}"></script>
		<script src="{ametys:skinURL('templates/common/js/components/hs.dropdown.js')}"></script>
		<script src="{ametys:skinURL('templates/common/js/components/hs.scrollbar.js')}"></script>
		<script src="{ametys:skinURL('templates/common/js/components/hs.carousel.js')}"></script>
		<script src="{ametys:skinURL('templates/common/js/components/hs.popup.js')}"></script>
		<script src="{ametys:skinURL('templates/common/js/components/hs.select.js')}"></script>
		
		<script src="{ametys:skinURL('templates/common/js/general.js')}"></script>
		<script src="{ametys:skinURL('templates/common/js/header.js')}"></script>
		<script src="{ametys:skinURL('templates/common/js/expandable-content.js')}"></script>
        <script src="{ametys:skinURL('templates/common/js/svgconvert.js')}"></script>
		
		<!-- Front notification -->
		<script type="text/javascript" src="{ametys:pluginResourceURL('front-notification', 'js/FlashInfo.js')}"></script>
        
		<xsl:call-template name="link-dynamic-info-js">
			<xsl:with-param name="themes" select="/cms/inputData/linkDirectory/themes"/>
		</xsl:call-template>
        
        <xsl:call-template name="head-js-matomo"/>
        
        <!-- Subscriptions -->
        <xsl:call-template name="head-js-subscriptions"/>
        
        <xsl:call-template name="head-fastsearch-script"/>
		
        <xsl:call-template name="custom-script"/>
    </xsl:template>
    
    <!-- + 
         | CUSTOM SCRIPTS
         + -->
    <xsl:template name="custom-script">
        <!-- Insert your custom scripts here-->
    </xsl:template>
    
    <!-- JS to follow page button and subscriptions notifications -->
    <xsl:template name="head-js-subscriptions">
        <xsl:if test="$pageFollowEnabled = 'true'">
           <script type="text/javascript" src="{$uri-prefix}/plugins/page-subscription/resources/js/AmetysFront/UserPageSubscriptions.{ametys:lang()}.js"/>
        </xsl:if>
        <xsl:if test="$notificationCenterEnabled = 'true'">
            <script type="text/javascript" src="{$uri-prefix}/plugins/page-subscription/resources/js/AmetysFront/UserNotifications.{ametys:lang()}.js"/>
            <script src="{ametys:skinURL('templates/common/plugins/moment/moment-with-locales.min.js')}"></script>
            <script type="text/javascript">
                moment.locale('<xsl:value-of select="$lang"/>');
            </script>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="head-js-matomo">
        <script src="{ametys:pluginResourceURL('web-analytics', 'js/AmetysMatomoHelper.js')}" type="text/javascript"/>
    </xsl:template>
	
	<xsl:template name="head-js-pirobox">
        <script src="{ametys:pluginResourceURL('pirobox_ext', 'pirobox_extended.js')}" type="text/javascript"></script>
	        <script type="text/javascript">
                $j(function() {
                    $j().piroBox_ext({
                        piro_speed: 600,
                        bg_alpha: 0.5,
                        piro_scroll: false,
                        prev_label: '<i18n:text i18n:key="WORKSPACE_WEB_PIROBOX_PREVIOUS" i18n:catalogue="workspace.web"/>',
                        next_label: '<i18n:text i18n:key="WORKSPACE_WEB_PIROBOX_NEXT" i18n:catalogue="workspace.web"/>',
                        close_label: '<i18n:text i18n:key="WORKSPACE_WEB_PIROBOX_CLOSE" i18n:catalogue="workspace.web"/>'
                    });
                });
	        </script>  
    </xsl:template>
	
	<!-- + 
         | ADDITIONNAL SCRIPT
         + -->
	<xsl:template name="additionnal-script"/>
	
	<xsl:template name="favico">
        <xsl:choose>
            <xsl:when test="ametys:skinResources('templates/common/img/favicon/favicon.ico')">
                <link rel="icon" type="image/x-icon" href="{ametys:skinURL('templates/common/img/favicon/favicon.ico')}" />
                <link rel="shortcut icon" type="image/x-icon" href="{ametys:skinURL('templates/common/img/favicon/favicon.ico')}" />
            </xsl:when>
            <xsl:otherwise>
                <link rel="icon" type="image/x-icon" href="{$uri-prefix}/favicon.ico" />
                <link rel="shortcut icon" type="image/x-icon" href="{$uri-prefix}/favicon.ico" />
            </xsl:otherwise>
        </xsl:choose>
        <meta name="msapplication-config" content="{ametys:skinURL('templates/common/img/favicon/browserconfig.xml')}" /> 
        <meta name="theme-color" content="#ffffff" /> 
    </xsl:template>
	
	<xsl:template name="head-meta-top">
		<meta content="IE=EDGE" http-equiv="X-UA-Compatible" />
    </xsl:template>	
    
    <xsl:template name="head-translations">
        <xsl:for-each select="/cms/page/metadata/translations/*">
            <link rel="alternate" href="{resolver:resolve('page', .)}" hreflang="{local-name()}" />
        </xsl:for-each>
    </xsl:template> 	
</xsl:stylesheet>
